/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.rest.impl;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.apache.rave.model.Widget;
import org.apache.rave.portal.model.impl.WidgetImpl;
import org.apache.rave.portal.service.WidgetService;
import org.apache.rave.rest.WidgetsResource;
import org.apache.rave.rest.exception.ResourceNotFoundException;
import org.apache.rave.rest.model.SearchResult;

public class DefaultWidgetsResource
implements WidgetsResource {
    private WidgetService widgetService;

    public SearchResult<org.apache.rave.rest.model.Widget> getWidgets() {
        SearchResult<Widget> fromDb = this.widgetService.getAll();
        List<org.apache.rave.rest.model.Widget> widget = this.convert(fromDb.getResultSet());
        return new SearchResult(widget, fromDb.getTotalResults());
    }

    public org.apache.rave.rest.model.Widget getWidget(String id) {
        Widget widget = this.getFromService(id);
        return new org.apache.rave.rest.model.Widget(widget);
    }

    public org.apache.rave.rest.model.Widget updateWidget(String id, org.apache.rave.rest.model.Widget widget) {
        Widget fromDb = this.getFromService(id);
        this.updateProperties(widget, fromDb);
        this.widgetService.updateWidget(fromDb);
        return new org.apache.rave.rest.model.Widget(this.getFromService(id));
    }

    public org.apache.rave.rest.model.Widget createWidget(org.apache.rave.rest.model.Widget widget) {
        WidgetImpl toDb = new WidgetImpl();
        toDb.setId(widget.getId());
        this.updateProperties(widget, toDb);
        return new org.apache.rave.rest.model.Widget(this.widgetService.registerNewWidget(toDb));
    }

    @Inject
    public void setWidgetService(WidgetService widgetService) {
        this.widgetService = widgetService;
    }

    private List<org.apache.rave.rest.model.Widget> convert(List<Widget> resultSet) {
        ArrayList widgets = Lists.newArrayListWithExpectedSize((int)resultSet.size());
        for (Widget widget : resultSet) {
            widgets.add(new org.apache.rave.rest.model.Widget(widget));
        }
        return widgets;
    }

    private Widget getFromService(String id) {
        Widget widget = this.widgetService.getWidget(id);
        if (widget == null) {
            throw new ResourceNotFoundException("Could not find widget with ID " + id);
        }
        return widget;
    }

    private void updateProperties(org.apache.rave.rest.model.Widget widget, Widget fromDb) {
        fromDb.setTitle(widget.getTitle());
        fromDb.setTitleUrl(widget.getTitleUrl());
        fromDb.setUrl(widget.getUrl());
        fromDb.setThumbnailUrl(widget.getThumbnailUrl());
        fromDb.setScreenshotUrl(widget.getScreenshotUrl());
        fromDb.setType(widget.getType());
        fromDb.setAuthor(widget.getAuthor());
        fromDb.setAuthorEmail(widget.getAuthorEmail());
        fromDb.setDescription(widget.getDescription());
        fromDb.setWidgetStatus(widget.getStatus());
        fromDb.setDisableRendering(widget.isDisable());
        fromDb.setDisableRenderingMessage(widget.getDisabledMessage());
        fromDb.setFeatured(widget.isFeatured());
        fromDb.setProperties(widget.getProperties());
    }
}

