/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.persistence.jpa;

import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.rave.jdbc.util.DataSourcePopulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;

public class PopulatedLocalContainerEntityManagerFactory
extends LocalContainerEntityManagerFactoryBean {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(PopulatedLocalContainerEntityManagerFactory.class);
    private DataSourcePopulator populator;

    public void setPopulator(DataSourcePopulator populator) {
        this.populator = populator;
    }

    protected void postProcessEntityManagerFactory(EntityManagerFactory emf, PersistenceUnitInfo pui) {
        if (this.populator != null) {
            emf.createEntityManager().close();
            try {
                this.populator.initialize(this.getDataSource());
            }
            catch (RuntimeException e) {
                logger.error("Database population has failed. It will be empty.", (Throwable)e);
            }
        }
        super.postProcessEntityManagerFactory(emf, pui);
    }
}

