/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.persistence.jpa.impl;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.rave.exception.DuplicateItemException;
import org.apache.rave.persistence.impl.TranslatedH2Exception;
import org.h2.jdbc.JdbcSQLException;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.jpa.vendor.OpenJpaDialect;

public class H2OpenJpaDialect
extends OpenJpaDialect {
    private static final long serialVersionUID = 1L;

    public DataAccessException translateExceptionIfPossible(RuntimeException re) {
        TranslatedH2Exception e = null;
        if (ExceptionUtils.getRootCause((Throwable)re) instanceof JdbcSQLException) {
            JdbcSQLException rootException = (JdbcSQLException)ExceptionUtils.getRootCause((Throwable)re);
            switch (rootException.getErrorCode()) {
                case 23505: {
                    e = new DuplicateItemException("DUPLICATE_ITEM", (Throwable)rootException);
                    break;
                }
                default: {
                    e = new TranslatedH2Exception(rootException.getErrorCode(), "ERROR", "Unknown Database Error");
                    break;
                }
            }
        } else {
            e = new TranslatedH2Exception(-1, "ERROR", "Unknown Runtime Exception");
        }
        return e;
    }
}

