/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.persistence.jpa.util;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.apache.rave.exception.NotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.IncorrectResultSizeDataAccessException;

public class JpaUtil {
    private static final Logger log = LoggerFactory.getLogger(JpaUtil.class);
    private static final int LARGE_PAGESIZE = 1000;

    private JpaUtil() {
    }

    public static <T> T getSingleResult(List<T> list) {
        if (list == null) {
            return null;
        }
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return list.get(0);
            }
        }
        throw new IncorrectResultSizeDataAccessException(1);
    }

    public static <T, I> T saveOrUpdate(I id, EntityManager entityManager, T entity) {
        if (id == null) {
            entityManager.persist(entity);
            return entity;
        }
        return (T)entityManager.merge(entity);
    }

    public static <T> List<T> getPagedResultList(TypedQuery<T> query, int offset, int pageSize) {
        if (pageSize >= 1000) {
            log.warn("Requesting potentially large resultset. Pagesize is {}", (Object)pageSize);
        }
        query.setFirstResult(offset).setMaxResults(pageSize);
        return query.getResultList();
    }

    public static <E, T extends E> void clearAndAdd(List<T> target, List<E> newList, Class<T> clazz) {
        target.clear();
        if (newList != null) {
            for (E e : newList) {
                if (e.getClass().equals(clazz)) {
                    target.add(e);
                    continue;
                }
                throw new NotSupportedException("Cannot directly set list composed of non JPA Entities");
            }
        }
    }
}

