/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.rave.model.PageLayout;
import org.apache.rave.model.PageTemplate;
import org.apache.rave.model.PageTemplateRegion;
import org.apache.rave.persistence.jpa.JpaSerializable;
import org.apache.rave.portal.model.BasicEntity;
import org.apache.rave.portal.model.JpaPageLayout;
import org.apache.rave.portal.model.JpaPageTemplateRegion;
import org.apache.rave.portal.model.conversion.ConvertingListProxyFactory;
import org.apache.rave.portal.model.conversion.JpaConverter;
import org.apache.rave.util.JsonUtils;

@Entity
@Table(name="page_template")
@NamedQueries(value={@NamedQuery(name="PageTemplate.getAll", query="SELECT p FROM JpaPageTemplate p WHERE p.pageType <> 'SUB_PAGE' ORDER BY p.renderSequence"), @NamedQuery(name="PageTemplate.getDefaultPage", query="SELECT p FROM JpaPageTemplate p WHERE p.defaultTemplate = true and p.pageType = :pageType"), @NamedQuery(name="PageTemplate.getAllByType", query="SELECT p FROM JpaPageTemplate p WHERE p.pageType = :pageType")})
@Access(value=AccessType.FIELD)
public class JpaPageTemplate
implements BasicEntity,
Serializable,
JpaSerializable,
PageTemplate,
PersistenceCapable {
    private static final long serialVersionUID = 1L;
    public static final String PAGE_TEMPLATE_GET_ALL = "PageTemplate.getAll";
    public static final String PAGE_TEMPLATE_GET_DEFAULT_PAGE_BY_TYPE = "PageTemplate.getDefaultPage";
    public static final String PAGE_TEMPLATE_GET_ALL_FOR_TYPE = "PageTemplate.getAllByType";
    @Id
    @Column(name="entity_id")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="pageTemplateIdGenerator")
    @TableGenerator(name="pageTemplateIdGenerator", table="RAVE_PORTAL_SEQUENCES", pkColumnName="SEQ_NAME", valueColumnName="SEQ_COUNT", pkColumnValue="page_template", allocationSize=1, initialValue=1)
    private Long entityId;
    @Basic
    @Column(name="name", unique=false)
    private String name;
    @Basic
    @Column(name="description", unique=false)
    private String description;
    @Basic(optional=false)
    @Column(name="page_type", unique=false)
    private String pageType;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="parent_page_template_id")
    private JpaPageTemplate parentPageTemplate;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="parentPageTemplate")
    @OrderBy(value="renderSequence")
    private List<JpaPageTemplate> subPageTemplates;
    @ManyToOne
    @JoinColumn(name="page_layout_id")
    private JpaPageLayout pageLayout;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="renderSequence")
    @JoinColumn(name="page_template_id")
    private List<JpaPageTemplateRegion> pageTemplateRegions;
    @Basic(optional=false)
    @Column(name="render_sequence")
    private long renderSequence;
    @Basic(optional=false)
    @Column(name="default_template")
    private boolean defaultTemplate;
    @Lob
    @JsonIgnore
    @Column(name="serialized_data")
    private String serializedData;
    @Transient
    private Map<String, Object> properties;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Lorg$apache$rave$portal$model$JpaPageLayout;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Lorg$apache$rave$portal$model$JpaPageTemplate;
    private transient Object pcDetachedState;

    @Override
    public Long getEntityId() {
        return JpaPageTemplate.pcGetentityId(this);
    }

    @Override
    public void setEntityId(Long entityId) {
        JpaPageTemplate.pcSetentityId(this, entityId);
    }

    public String getPageType() {
        return JpaPageTemplate.pcGetpageType(this);
    }

    public void setPageType(String pageType) {
        JpaPageTemplate.pcSetpageType(this, pageType);
    }

    public String getName() {
        return JpaPageTemplate.pcGetname(this);
    }

    public void setName(String name) {
        JpaPageTemplate.pcSetname(this, name);
    }

    public String getDescription() {
        return JpaPageTemplate.pcGetdescription(this);
    }

    public void setDescription(String description) {
        JpaPageTemplate.pcSetdescription(this, description);
    }

    public PageTemplate getParentPageTemplate() {
        return JpaPageTemplate.pcGetparentPageTemplate(this);
    }

    public void setParentPageTemplate(PageTemplate parentPageTemplate) {
        JpaPageTemplate.pcSetparentPageTemplate(this, (JpaPageTemplate)JpaConverter.getInstance().convert(parentPageTemplate, PageTemplate.class));
    }

    public PageLayout getPageLayout() {
        return JpaPageTemplate.pcGetpageLayout(this);
    }

    public void setPageLayout(PageLayout pageLayout) {
        JpaPageTemplate.pcSetpageLayout(this, (JpaPageLayout)JpaConverter.getInstance().convert(pageLayout, PageLayout.class));
    }

    public List<PageTemplateRegion> getPageTemplateRegions() {
        return ConvertingListProxyFactory.createProxyList(PageTemplateRegion.class, JpaPageTemplate.pcGetpageTemplateRegions(this));
    }

    public void setPageTemplateRegions(List<PageTemplateRegion> pageTemplateRegions) {
        if (JpaPageTemplate.pcGetpageTemplateRegions(this) == null) {
            JpaPageTemplate.pcSetpageTemplateRegions(this, new ArrayList());
        }
        this.getPageTemplateRegions().clear();
        if (pageTemplateRegions != null) {
            for (PageTemplateRegion region : pageTemplateRegions) {
                region.setPageTemplate((PageTemplate)this);
                this.getPageTemplateRegions().add(region);
            }
        }
    }

    public long getRenderSequence() {
        return JpaPageTemplate.pcGetrenderSequence(this);
    }

    public void setRenderSequence(long renderSequence) {
        JpaPageTemplate.pcSetrenderSequence(this, renderSequence);
    }

    public boolean isDefaultTemplate() {
        return JpaPageTemplate.pcGetdefaultTemplate(this);
    }

    public void setDefaultTemplate(boolean defaultTemplate) {
        JpaPageTemplate.pcSetdefaultTemplate(this, defaultTemplate);
    }

    public List<PageTemplate> getSubPageTemplates() {
        return ConvertingListProxyFactory.createProxyList(PageTemplate.class, JpaPageTemplate.pcGetsubPageTemplates(this));
    }

    public void setSubPageTemplates(List<PageTemplate> subPageTemplates) {
        if (JpaPageTemplate.pcGetsubPageTemplates(this) == null) {
            JpaPageTemplate.pcSetsubPageTemplates(this, new ArrayList());
        }
        this.getSubPageTemplates().clear();
        if (subPageTemplates != null) {
            for (PageTemplate subPageTemplate : subPageTemplates) {
                subPageTemplate.setParentPageTemplate((PageTemplate)this);
                this.getSubPageTemplates().add(subPageTemplate);
            }
        }
    }

    public String getId() {
        return this.getEntityId() == null ? null : this.getEntityId().toString();
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public void serializeData() {
        Map<String, Object> properties = this.getProperties();
        if (properties != null) {
            JpaPageTemplate.pcSetserializedData(this, JsonUtils.stringify(properties));
        }
    }

    @Override
    public void deserializeData() {
        if (JpaPageTemplate.pcGetserializedData(this) != null) {
            this.setProperties((Map)JsonUtils.parse((String)JpaPageTemplate.pcGetserializedData(this), Map.class));
        }
    }

    public int pcGetEnhancementContractVersion() {
        return 1468245;
    }

    static {
        pcFieldNames = new String[]{"defaultTemplate", "description", "entityId", "name", "pageLayout", "pageTemplateRegions", "pageType", "parentPageTemplate", "renderSequence", "serializedData", "subPageTemplates"};
        Class[] classArray = new Class[11];
        classArray[0] = Boolean.TYPE;
        Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaPageTemplate.class$("java.lang.String"));
        classArray[1] = clazz;
        Class clazz2 = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = JpaPageTemplate.class$("java.lang.Long"));
        classArray[2] = clazz2;
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaPageTemplate.class$("java.lang.String"));
        Class clazz3 = class$Lorg$apache$rave$portal$model$JpaPageLayout != null ? class$Lorg$apache$rave$portal$model$JpaPageLayout : (class$Lorg$apache$rave$portal$model$JpaPageLayout = JpaPageTemplate.class$("org.apache.rave.portal.model.JpaPageLayout"));
        classArray[4] = clazz3;
        Class clazz4 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JpaPageTemplate.class$("java.util.List"));
        classArray[5] = clazz4;
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaPageTemplate.class$("java.lang.String"));
        Class clazz5 = class$Lorg$apache$rave$portal$model$JpaPageTemplate != null ? class$Lorg$apache$rave$portal$model$JpaPageTemplate : (class$Lorg$apache$rave$portal$model$JpaPageTemplate = JpaPageTemplate.class$("org.apache.rave.portal.model.JpaPageTemplate"));
        classArray[7] = clazz5;
        classArray[8] = Long.TYPE;
        classArray[9] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaPageTemplate.class$("java.lang.String"));
        classArray[10] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JpaPageTemplate.class$("java.util.List"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 10, 26, 26, 26, 26, 10};
        PCRegistry.register((Class)(class$Lorg$apache$rave$portal$model$JpaPageTemplate != null ? class$Lorg$apache$rave$portal$model$JpaPageTemplate : (class$Lorg$apache$rave$portal$model$JpaPageTemplate = JpaPageTemplate.class$("org.apache.rave.portal.model.JpaPageTemplate"))), (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JpaPageTemplate", (PersistenceCapable)new JpaPageTemplate());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.defaultTemplate = false;
        this.description = null;
        this.entityId = null;
        this.name = null;
        this.pageLayout = null;
        this.pageTemplateRegions = null;
        this.pageType = null;
        this.parentPageTemplate = null;
        this.renderSequence = 0L;
        this.serializedData = null;
        this.subPageTemplates = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JpaPageTemplate jpaPageTemplate = new JpaPageTemplate();
        if (bl) {
            jpaPageTemplate.pcClearFields();
        }
        jpaPageTemplate.pcStateManager = stateManager;
        jpaPageTemplate.pcCopyKeyFieldsFromObjectId(object);
        return jpaPageTemplate;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JpaPageTemplate jpaPageTemplate = new JpaPageTemplate();
        if (bl) {
            jpaPageTemplate.pcClearFields();
        }
        jpaPageTemplate.pcStateManager = stateManager;
        return jpaPageTemplate;
    }

    protected static int pcGetManagedFieldCount() {
        return 11;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.defaultTemplate = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.description = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.entityId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.pageLayout = (JpaPageLayout)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.pageTemplateRegions = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.pageType = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.parentPageTemplate = (JpaPageTemplate)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.renderSequence = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.serializedData = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.subPageTemplates = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.defaultTemplate);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.description);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.entityId);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.pageLayout);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.pageTemplateRegions);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.pageType);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.parentPageTemplate);
                return;
            }
            case 8: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.renderSequence);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.serializedData);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.subPageTemplates);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JpaPageTemplate jpaPageTemplate, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.defaultTemplate = jpaPageTemplate.defaultTemplate;
                return;
            }
            case 1: {
                this.description = jpaPageTemplate.description;
                return;
            }
            case 2: {
                this.entityId = jpaPageTemplate.entityId;
                return;
            }
            case 3: {
                this.name = jpaPageTemplate.name;
                return;
            }
            case 4: {
                this.pageLayout = jpaPageTemplate.pageLayout;
                return;
            }
            case 5: {
                this.pageTemplateRegions = jpaPageTemplate.pageTemplateRegions;
                return;
            }
            case 6: {
                this.pageType = jpaPageTemplate.pageType;
                return;
            }
            case 7: {
                this.parentPageTemplate = jpaPageTemplate.parentPageTemplate;
                return;
            }
            case 8: {
                this.renderSequence = jpaPageTemplate.renderSequence;
                return;
            }
            case 9: {
                this.serializedData = jpaPageTemplate.serializedData;
                return;
            }
            case 10: {
                this.subPageTemplates = jpaPageTemplate.subPageTemplates;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        JpaPageTemplate jpaPageTemplate = (JpaPageTemplate)object;
        if (jpaPageTemplate.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jpaPageTemplate, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(2 + pcInheritedFieldCount, (Object)new Long(longId.getId()));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this.entityId = new Long(longId.getId());
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$rave$portal$model$JpaPageTemplate != null ? class$Lorg$apache$rave$portal$model$JpaPageTemplate : (class$Lorg$apache$rave$portal$model$JpaPageTemplate = JpaPageTemplate.class$("org.apache.rave.portal.model.JpaPageTemplate"));
        return new LongId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$rave$portal$model$JpaPageTemplate != null ? class$Lorg$apache$rave$portal$model$JpaPageTemplate : (class$Lorg$apache$rave$portal$model$JpaPageTemplate = JpaPageTemplate.class$("org.apache.rave.portal.model.JpaPageTemplate"));
        return new LongId(clazz, this.entityId);
    }

    private static final boolean pcGetdefaultTemplate(JpaPageTemplate jpaPageTemplate) {
        if (jpaPageTemplate.pcStateManager == null) {
            return jpaPageTemplate.defaultTemplate;
        }
        int n = pcInheritedFieldCount + 0;
        jpaPageTemplate.pcStateManager.accessingField(n);
        return jpaPageTemplate.defaultTemplate;
    }

    private static final void pcSetdefaultTemplate(JpaPageTemplate jpaPageTemplate, boolean bl) {
        if (jpaPageTemplate.pcStateManager == null) {
            jpaPageTemplate.defaultTemplate = bl;
            return;
        }
        jpaPageTemplate.pcStateManager.settingBooleanField((PersistenceCapable)jpaPageTemplate, pcInheritedFieldCount + 0, jpaPageTemplate.defaultTemplate, bl, 0);
    }

    private static final String pcGetdescription(JpaPageTemplate jpaPageTemplate) {
        if (jpaPageTemplate.pcStateManager == null) {
            return jpaPageTemplate.description;
        }
        int n = pcInheritedFieldCount + 1;
        jpaPageTemplate.pcStateManager.accessingField(n);
        return jpaPageTemplate.description;
    }

    private static final void pcSetdescription(JpaPageTemplate jpaPageTemplate, String string) {
        if (jpaPageTemplate.pcStateManager == null) {
            jpaPageTemplate.description = string;
            return;
        }
        jpaPageTemplate.pcStateManager.settingStringField((PersistenceCapable)jpaPageTemplate, pcInheritedFieldCount + 1, jpaPageTemplate.description, string, 0);
    }

    private static final Long pcGetentityId(JpaPageTemplate jpaPageTemplate) {
        if (jpaPageTemplate.pcStateManager == null) {
            return jpaPageTemplate.entityId;
        }
        int n = pcInheritedFieldCount + 2;
        jpaPageTemplate.pcStateManager.accessingField(n);
        return jpaPageTemplate.entityId;
    }

    private static final void pcSetentityId(JpaPageTemplate jpaPageTemplate, Long l) {
        if (jpaPageTemplate.pcStateManager == null) {
            jpaPageTemplate.entityId = l;
            return;
        }
        jpaPageTemplate.pcStateManager.settingObjectField((PersistenceCapable)jpaPageTemplate, pcInheritedFieldCount + 2, (Object)jpaPageTemplate.entityId, (Object)l, 0);
    }

    private static final String pcGetname(JpaPageTemplate jpaPageTemplate) {
        if (jpaPageTemplate.pcStateManager == null) {
            return jpaPageTemplate.name;
        }
        int n = pcInheritedFieldCount + 3;
        jpaPageTemplate.pcStateManager.accessingField(n);
        return jpaPageTemplate.name;
    }

    private static final void pcSetname(JpaPageTemplate jpaPageTemplate, String string) {
        if (jpaPageTemplate.pcStateManager == null) {
            jpaPageTemplate.name = string;
            return;
        }
        jpaPageTemplate.pcStateManager.settingStringField((PersistenceCapable)jpaPageTemplate, pcInheritedFieldCount + 3, jpaPageTemplate.name, string, 0);
    }

    private static final JpaPageLayout pcGetpageLayout(JpaPageTemplate jpaPageTemplate) {
        if (jpaPageTemplate.pcStateManager == null) {
            return jpaPageTemplate.pageLayout;
        }
        int n = pcInheritedFieldCount + 4;
        jpaPageTemplate.pcStateManager.accessingField(n);
        return jpaPageTemplate.pageLayout;
    }

    private static final void pcSetpageLayout(JpaPageTemplate jpaPageTemplate, JpaPageLayout jpaPageLayout) {
        if (jpaPageTemplate.pcStateManager == null) {
            jpaPageTemplate.pageLayout = jpaPageLayout;
            return;
        }
        jpaPageTemplate.pcStateManager.settingObjectField((PersistenceCapable)jpaPageTemplate, pcInheritedFieldCount + 4, (Object)jpaPageTemplate.pageLayout, (Object)jpaPageLayout, 0);
    }

    private static final List pcGetpageTemplateRegions(JpaPageTemplate jpaPageTemplate) {
        if (jpaPageTemplate.pcStateManager == null) {
            return jpaPageTemplate.pageTemplateRegions;
        }
        int n = pcInheritedFieldCount + 5;
        jpaPageTemplate.pcStateManager.accessingField(n);
        return jpaPageTemplate.pageTemplateRegions;
    }

    private static final void pcSetpageTemplateRegions(JpaPageTemplate jpaPageTemplate, List list) {
        if (jpaPageTemplate.pcStateManager == null) {
            jpaPageTemplate.pageTemplateRegions = list;
            return;
        }
        jpaPageTemplate.pcStateManager.settingObjectField((PersistenceCapable)jpaPageTemplate, pcInheritedFieldCount + 5, jpaPageTemplate.pageTemplateRegions, (Object)list, 0);
    }

    private static final String pcGetpageType(JpaPageTemplate jpaPageTemplate) {
        if (jpaPageTemplate.pcStateManager == null) {
            return jpaPageTemplate.pageType;
        }
        int n = pcInheritedFieldCount + 6;
        jpaPageTemplate.pcStateManager.accessingField(n);
        return jpaPageTemplate.pageType;
    }

    private static final void pcSetpageType(JpaPageTemplate jpaPageTemplate, String string) {
        if (jpaPageTemplate.pcStateManager == null) {
            jpaPageTemplate.pageType = string;
            return;
        }
        jpaPageTemplate.pcStateManager.settingStringField((PersistenceCapable)jpaPageTemplate, pcInheritedFieldCount + 6, jpaPageTemplate.pageType, string, 0);
    }

    private static final JpaPageTemplate pcGetparentPageTemplate(JpaPageTemplate jpaPageTemplate) {
        if (jpaPageTemplate.pcStateManager == null) {
            return jpaPageTemplate.parentPageTemplate;
        }
        int n = pcInheritedFieldCount + 7;
        jpaPageTemplate.pcStateManager.accessingField(n);
        return jpaPageTemplate.parentPageTemplate;
    }

    private static final void pcSetparentPageTemplate(JpaPageTemplate jpaPageTemplate, JpaPageTemplate jpaPageTemplate2) {
        if (jpaPageTemplate.pcStateManager == null) {
            jpaPageTemplate.parentPageTemplate = jpaPageTemplate2;
            return;
        }
        jpaPageTemplate.pcStateManager.settingObjectField((PersistenceCapable)jpaPageTemplate, pcInheritedFieldCount + 7, (Object)jpaPageTemplate.parentPageTemplate, (Object)jpaPageTemplate2, 0);
    }

    private static final long pcGetrenderSequence(JpaPageTemplate jpaPageTemplate) {
        if (jpaPageTemplate.pcStateManager == null) {
            return jpaPageTemplate.renderSequence;
        }
        int n = pcInheritedFieldCount + 8;
        jpaPageTemplate.pcStateManager.accessingField(n);
        return jpaPageTemplate.renderSequence;
    }

    private static final void pcSetrenderSequence(JpaPageTemplate jpaPageTemplate, long l) {
        if (jpaPageTemplate.pcStateManager == null) {
            jpaPageTemplate.renderSequence = l;
            return;
        }
        jpaPageTemplate.pcStateManager.settingLongField((PersistenceCapable)jpaPageTemplate, pcInheritedFieldCount + 8, jpaPageTemplate.renderSequence, l, 0);
    }

    private static final String pcGetserializedData(JpaPageTemplate jpaPageTemplate) {
        if (jpaPageTemplate.pcStateManager == null) {
            return jpaPageTemplate.serializedData;
        }
        int n = pcInheritedFieldCount + 9;
        jpaPageTemplate.pcStateManager.accessingField(n);
        return jpaPageTemplate.serializedData;
    }

    private static final void pcSetserializedData(JpaPageTemplate jpaPageTemplate, String string) {
        if (jpaPageTemplate.pcStateManager == null) {
            jpaPageTemplate.serializedData = string;
            return;
        }
        jpaPageTemplate.pcStateManager.settingStringField((PersistenceCapable)jpaPageTemplate, pcInheritedFieldCount + 9, jpaPageTemplate.serializedData, string, 0);
    }

    private static final List pcGetsubPageTemplates(JpaPageTemplate jpaPageTemplate) {
        if (jpaPageTemplate.pcStateManager == null) {
            return jpaPageTemplate.subPageTemplates;
        }
        int n = pcInheritedFieldCount + 10;
        jpaPageTemplate.pcStateManager.accessingField(n);
        return jpaPageTemplate.subPageTemplates;
    }

    private static final void pcSetsubPageTemplates(JpaPageTemplate jpaPageTemplate, List list) {
        if (jpaPageTemplate.pcStateManager == null) {
            jpaPageTemplate.subPageTemplates = list;
            return;
        }
        jpaPageTemplate.pcStateManager.settingObjectField((PersistenceCapable)jpaPageTemplate, pcInheritedFieldCount + 10, jpaPageTemplate.subPageTemplates, (Object)list, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.entityId != null) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        if (this.pcGetDetachedState() == null) {
            return Boolean.FALSE;
        }
        return null;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

