/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.rave.model.Page;
import org.apache.rave.model.PageInvitationStatus;
import org.apache.rave.model.PageUser;
import org.apache.rave.model.User;
import org.apache.rave.portal.model.BasicEntity;
import org.apache.rave.portal.model.JpaPage;
import org.apache.rave.portal.model.conversion.JpaConverter;

@Entity
@Access(value=AccessType.FIELD)
@Table(name="page_user", uniqueConstraints={@UniqueConstraint(columnNames={"page_id", "user_id"})})
@NamedQueries(value={@NamedQuery(name="JpaPageUser.getByUserIdAndPageType", query="SELECT p.page FROM JpaPageUser p, JpaPage q WHERE p.page.entityId = q.entityId and p.userId = :userId and q.pageType = :pageType ORDER BY p.renderSequence"), @NamedQuery(name="JpaPageUser.getPagesForUser", query="SELECT p FROM JpaPageUser p, JpaPage q WHERE p.page.entityId = q.entityId and p.userId = :userId and q.pageType = :pageType ORDER BY p.renderSequence"), @NamedQuery(name="JpaPageUser.getSingleRecord", query="SELECT p FROM JpaPageUser p WHERE p.userId = :userId and p.page.entityId = :pageId")})
public class JpaPageUser
implements BasicEntity,
Serializable,
PageUser,
PersistenceCapable {
    private static final long serialVersionUID = 1L;
    public static final String GET_BY_USER_ID_AND_PAGE_TYPE = "JpaPageUser.getByUserIdAndPageType";
    public static final String GET_PAGES_FOR_USER = "JpaPageUser.getPagesForUser";
    public static final String GET_SINGLE_RECORD = "JpaPageUser.getSingleRecord";
    @Id
    @Column(name="entity_id")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="pageUserIdGenerator")
    @TableGenerator(name="pageUserIdGenerator", table="RAVE_PORTAL_SEQUENCES", pkColumnName="SEQ_NAME", valueColumnName="SEQ_COUNT", pkColumnValue="page_user", allocationSize=1, initialValue=1)
    private Long entityId;
    @Basic
    @Column(name="user_id")
    private String userId;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="page_id")
    private JpaPage page;
    @Basic(optional=false)
    @Column(name="editor")
    private boolean editor;
    @Basic(optional=false)
    @Column(name="render_sequence")
    private Long renderSequence;
    @Basic
    @Column(name="page_status")
    @Enumerated(value=EnumType.STRING)
    private PageInvitationStatus pageStatus;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Lorg$apache$rave$portal$model$JpaPage;
    static /* synthetic */ Class class$Lorg$apache$rave$model$PageInvitationStatus;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$rave$portal$model$JpaPageUser;
    private transient Object pcDetachedState;

    public JpaPageUser() {
    }

    public JpaPageUser(User user, Page page) {
        this.setUserId(user.getId());
        this.setPage(page);
    }

    public JpaPageUser(User user, Page page, long sequence) {
        this.userId = user.getId();
        this.setPage(page);
        this.renderSequence = sequence;
    }

    public JpaPageUser(String userId, Page page, long sequence) {
        this.userId = userId;
        this.setPage(page);
        this.renderSequence = sequence;
    }

    @Override
    public Long getEntityId() {
        return JpaPageUser.pcGetentityId(this);
    }

    @Override
    public void setEntityId(Long entityId) {
        JpaPageUser.pcSetentityId(this, entityId);
    }

    public String getId() {
        return this.getEntityId() == null ? null : this.getEntityId().toString();
    }

    public boolean isEditor() {
        return JpaPageUser.pcGeteditor(this);
    }

    public void setEditor(boolean editor) {
        JpaPageUser.pcSeteditor(this, editor);
    }

    public String getUserId() {
        return JpaPageUser.pcGetuserId(this);
    }

    public void setUserId(String userId) {
        JpaPageUser.pcSetuserId(this, userId);
    }

    @JsonBackReference
    public Page getPage() {
        return JpaPageUser.pcGetpage(this);
    }

    public void setPage(Page page) {
        JpaPageUser.pcSetpage(this, (JpaPage)JpaConverter.getInstance().convert(page, Page.class));
    }

    public Long getRenderSequence() {
        return JpaPageUser.pcGetrenderSequence(this);
    }

    public void setRenderSequence(Long renderSequence) {
        JpaPageUser.pcSetrenderSequence(this, renderSequence);
    }

    public PageInvitationStatus getPageStatus() {
        return JpaPageUser.pcGetpageStatus(this);
    }

    public void setPageStatus(PageInvitationStatus pageStatus) {
        JpaPageUser.pcSetpageStatus(this, pageStatus);
    }

    public int pcGetEnhancementContractVersion() {
        return 1468245;
    }

    static {
        pcFieldNames = new String[]{"editor", "entityId", "page", "pageStatus", "renderSequence", "userId"};
        Class[] classArray = new Class[6];
        classArray[0] = Boolean.TYPE;
        Class clazz = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = JpaPageUser.class$("java.lang.Long"));
        classArray[1] = clazz;
        Class clazz2 = class$Lorg$apache$rave$portal$model$JpaPage != null ? class$Lorg$apache$rave$portal$model$JpaPage : (class$Lorg$apache$rave$portal$model$JpaPage = JpaPageUser.class$("org.apache.rave.portal.model.JpaPage"));
        classArray[2] = clazz2;
        Class clazz3 = class$Lorg$apache$rave$model$PageInvitationStatus != null ? class$Lorg$apache$rave$model$PageInvitationStatus : (class$Lorg$apache$rave$model$PageInvitationStatus = JpaPageUser.class$("org.apache.rave.model.PageInvitationStatus"));
        classArray[3] = clazz3;
        classArray[4] = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = JpaPageUser.class$("java.lang.Long"));
        Class clazz4 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaPageUser.class$("java.lang.String"));
        classArray[5] = clazz4;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26};
        Class clazz5 = class$Lorg$apache$rave$portal$model$JpaPageUser != null ? class$Lorg$apache$rave$portal$model$JpaPageUser : (class$Lorg$apache$rave$portal$model$JpaPageUser = JpaPageUser.class$("org.apache.rave.portal.model.JpaPageUser"));
        PCRegistry.register((Class)clazz5, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JpaPageUser", (PersistenceCapable)new JpaPageUser());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.editor = false;
        this.entityId = null;
        this.page = null;
        this.pageStatus = null;
        this.renderSequence = null;
        this.userId = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JpaPageUser jpaPageUser = new JpaPageUser();
        if (bl) {
            jpaPageUser.pcClearFields();
        }
        jpaPageUser.pcStateManager = stateManager;
        jpaPageUser.pcCopyKeyFieldsFromObjectId(object);
        return jpaPageUser;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JpaPageUser jpaPageUser = new JpaPageUser();
        if (bl) {
            jpaPageUser.pcClearFields();
        }
        jpaPageUser.pcStateManager = stateManager;
        return jpaPageUser;
    }

    protected static int pcGetManagedFieldCount() {
        return 6;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.editor = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.entityId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.page = (JpaPage)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.pageStatus = (PageInvitationStatus)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.renderSequence = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.userId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.editor);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.entityId);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.page);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.pageStatus);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.renderSequence);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.userId);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JpaPageUser jpaPageUser, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.editor = jpaPageUser.editor;
                return;
            }
            case 1: {
                this.entityId = jpaPageUser.entityId;
                return;
            }
            case 2: {
                this.page = jpaPageUser.page;
                return;
            }
            case 3: {
                this.pageStatus = jpaPageUser.pageStatus;
                return;
            }
            case 4: {
                this.renderSequence = jpaPageUser.renderSequence;
                return;
            }
            case 5: {
                this.userId = jpaPageUser.userId;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        JpaPageUser jpaPageUser = (JpaPageUser)object;
        if (jpaPageUser.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jpaPageUser, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(1 + pcInheritedFieldCount, (Object)new Long(longId.getId()));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this.entityId = new Long(longId.getId());
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$rave$portal$model$JpaPageUser != null ? class$Lorg$apache$rave$portal$model$JpaPageUser : (class$Lorg$apache$rave$portal$model$JpaPageUser = JpaPageUser.class$("org.apache.rave.portal.model.JpaPageUser"));
        return new LongId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$rave$portal$model$JpaPageUser != null ? class$Lorg$apache$rave$portal$model$JpaPageUser : (class$Lorg$apache$rave$portal$model$JpaPageUser = JpaPageUser.class$("org.apache.rave.portal.model.JpaPageUser"));
        return new LongId(clazz, this.entityId);
    }

    private static final boolean pcGeteditor(JpaPageUser jpaPageUser) {
        if (jpaPageUser.pcStateManager == null) {
            return jpaPageUser.editor;
        }
        int n = pcInheritedFieldCount + 0;
        jpaPageUser.pcStateManager.accessingField(n);
        return jpaPageUser.editor;
    }

    private static final void pcSeteditor(JpaPageUser jpaPageUser, boolean bl) {
        if (jpaPageUser.pcStateManager == null) {
            jpaPageUser.editor = bl;
            return;
        }
        jpaPageUser.pcStateManager.settingBooleanField((PersistenceCapable)jpaPageUser, pcInheritedFieldCount + 0, jpaPageUser.editor, bl, 0);
    }

    private static final Long pcGetentityId(JpaPageUser jpaPageUser) {
        if (jpaPageUser.pcStateManager == null) {
            return jpaPageUser.entityId;
        }
        int n = pcInheritedFieldCount + 1;
        jpaPageUser.pcStateManager.accessingField(n);
        return jpaPageUser.entityId;
    }

    private static final void pcSetentityId(JpaPageUser jpaPageUser, Long l) {
        if (jpaPageUser.pcStateManager == null) {
            jpaPageUser.entityId = l;
            return;
        }
        jpaPageUser.pcStateManager.settingObjectField((PersistenceCapable)jpaPageUser, pcInheritedFieldCount + 1, (Object)jpaPageUser.entityId, (Object)l, 0);
    }

    private static final JpaPage pcGetpage(JpaPageUser jpaPageUser) {
        if (jpaPageUser.pcStateManager == null) {
            return jpaPageUser.page;
        }
        int n = pcInheritedFieldCount + 2;
        jpaPageUser.pcStateManager.accessingField(n);
        return jpaPageUser.page;
    }

    private static final void pcSetpage(JpaPageUser jpaPageUser, JpaPage jpaPage) {
        if (jpaPageUser.pcStateManager == null) {
            jpaPageUser.page = jpaPage;
            return;
        }
        jpaPageUser.pcStateManager.settingObjectField((PersistenceCapable)jpaPageUser, pcInheritedFieldCount + 2, (Object)jpaPageUser.page, (Object)jpaPage, 0);
    }

    private static final PageInvitationStatus pcGetpageStatus(JpaPageUser jpaPageUser) {
        if (jpaPageUser.pcStateManager == null) {
            return jpaPageUser.pageStatus;
        }
        int n = pcInheritedFieldCount + 3;
        jpaPageUser.pcStateManager.accessingField(n);
        return jpaPageUser.pageStatus;
    }

    private static final void pcSetpageStatus(JpaPageUser jpaPageUser, PageInvitationStatus pageInvitationStatus) {
        if (jpaPageUser.pcStateManager == null) {
            jpaPageUser.pageStatus = pageInvitationStatus;
            return;
        }
        jpaPageUser.pcStateManager.settingObjectField((PersistenceCapable)jpaPageUser, pcInheritedFieldCount + 3, (Object)jpaPageUser.pageStatus, (Object)pageInvitationStatus, 0);
    }

    private static final Long pcGetrenderSequence(JpaPageUser jpaPageUser) {
        if (jpaPageUser.pcStateManager == null) {
            return jpaPageUser.renderSequence;
        }
        int n = pcInheritedFieldCount + 4;
        jpaPageUser.pcStateManager.accessingField(n);
        return jpaPageUser.renderSequence;
    }

    private static final void pcSetrenderSequence(JpaPageUser jpaPageUser, Long l) {
        if (jpaPageUser.pcStateManager == null) {
            jpaPageUser.renderSequence = l;
            return;
        }
        jpaPageUser.pcStateManager.settingObjectField((PersistenceCapable)jpaPageUser, pcInheritedFieldCount + 4, (Object)jpaPageUser.renderSequence, (Object)l, 0);
    }

    private static final String pcGetuserId(JpaPageUser jpaPageUser) {
        if (jpaPageUser.pcStateManager == null) {
            return jpaPageUser.userId;
        }
        int n = pcInheritedFieldCount + 5;
        jpaPageUser.pcStateManager.accessingField(n);
        return jpaPageUser.userId;
    }

    private static final void pcSetuserId(JpaPageUser jpaPageUser, String string) {
        if (jpaPageUser.pcStateManager == null) {
            jpaPageUser.userId = string;
            return;
        }
        jpaPageUser.pcStateManager.settingStringField((PersistenceCapable)jpaPageUser, pcInheritedFieldCount + 5, jpaPageUser.userId, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.entityId != null) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        if (this.pcGetDetachedState() == null) {
            return Boolean.FALSE;
        }
        return null;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

