/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.rave.model.Region;
import org.apache.rave.model.RegionWidget;
import org.apache.rave.model.RegionWidgetPreference;
import org.apache.rave.portal.model.BasicEntity;
import org.apache.rave.portal.model.JpaRegion;
import org.apache.rave.portal.model.JpaRegionWidgetPreference;
import org.apache.rave.portal.model.conversion.ConvertingListProxyFactory;
import org.apache.rave.portal.model.conversion.JpaConverter;

@Entity
@Access(value=AccessType.FIELD)
@Table(name="region_widget")
@NamedQueries(value={@NamedQuery(name="JpaRegionWidget.getDistinctUserCountForAllWidgets", query="select rw.widgetId, count(distinct rw.region.page.ownerId) from JpaRegionWidget rw group by rw.widgetId"), @NamedQuery(name="JpaRegionWidget.getDistinctUserCount", query="select count(distinct rw.region.page.ownerId) from JpaRegionWidget rw where rw.widgetId = :widgetId"), @NamedQuery(name="RegionWidget.findById", query="select rw from JpaRegionWidget rw where rw.entityId = :widgetId"), @NamedQuery(name="JpaRegionWidget.getAll", query="SELECT r FROM JpaRegionWidget r order by r.entityId"), @NamedQuery(name="JpaRegionWidget.countAll", query="SELECT count(r) FROM JpaRegionWidget r ")})
public class JpaRegionWidget
implements BasicEntity,
Serializable,
RegionWidget,
PersistenceCapable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_ID = "RegionWidget.findById";
    public static final String REGION_WIDGET_GET_DISTINCT_USER_COUNT_ALL_WIDGETS = "JpaRegionWidget.getDistinctUserCountForAllWidgets";
    public static final String REGION_WIDGET_GET_DISTINCT_USER_COUNT_SINGLE_WIDGET = "JpaRegionWidget.getDistinctUserCount";
    public static final String REGION_WIDGET_GET_ALL = "JpaRegionWidget.getAll";
    public static final String REGION_WIDGET_COUNT_ALL = "JpaRegionWidget.countAll";
    public static final String PARAM_WIDGET_ID = "widgetId";
    static final String SELECT_R_FROM_REGION_WIDGET_R = "SELECT r FROM JpaRegionWidget r order by r.entityId";
    static final String SELECT_COUNT_R_FROM_REGION_WIDGET_R = "SELECT count(r) FROM JpaRegionWidget r ";
    @Id
    @Column(name="entity_id")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="regionWidgetIdGenerator")
    @TableGenerator(name="regionWidgetIdGenerator", table="RAVE_PORTAL_SEQUENCES", pkColumnName="SEQ_NAME", valueColumnName="SEQ_COUNT", pkColumnValue="region_widget", allocationSize=1, initialValue=1)
    private Long entityId;
    @Basic
    @Column(name="widget_id")
    private Long widgetId;
    @ManyToOne
    @JoinColumn(name="region_id")
    private JpaRegion region;
    @Basic
    @Column(name="render_position")
    private String renderPosition;
    @Basic
    @Column(name="render_order")
    private int renderOrder;
    @Basic
    @Column(name="collapsed")
    private boolean collapsed;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="region_widget_id", referencedColumnName="entity_id")
    private List<JpaRegionWidgetPreference> preferences;
    @Basic(optional=false)
    @Column(name="locked")
    private boolean locked;
    @Basic(optional=false)
    @Column(name="hide_chrome")
    private boolean hideChrome;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Lorg$apache$rave$portal$model$JpaRegion;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$rave$portal$model$JpaRegionWidget;
    private transient Object pcDetachedState;

    public JpaRegionWidget() {
    }

    public JpaRegionWidget(Long entityId) {
        this.entityId = entityId;
    }

    public JpaRegionWidget(Long entityId, Long widgetId, JpaRegion region, int renderOrder) {
        this.entityId = entityId;
        this.widgetId = widgetId;
        this.region = region;
        this.renderOrder = renderOrder;
    }

    public JpaRegionWidget(Long entityId, Long widgetId, JpaRegion region) {
        this.entityId = entityId;
        this.widgetId = widgetId;
        this.region = region;
    }

    @Override
    public Long getEntityId() {
        return JpaRegionWidget.pcGetentityId(this);
    }

    @Override
    public void setEntityId(Long entityId) {
        JpaRegionWidget.pcSetentityId(this, entityId);
    }

    public String getId() {
        return this.getEntityId() == null ? null : this.getEntityId().toString();
    }

    public String getWidgetId() {
        return JpaRegionWidget.pcGetwidgetId(this).toString();
    }

    public void setWidgetId(String widgetId) {
        JpaRegionWidget.pcSetwidgetId(this, Long.parseLong(widgetId));
    }

    @JsonBackReference
    public Region getRegion() {
        return JpaRegionWidget.pcGetregion(this);
    }

    public void setRegion(Region region) {
        JpaRegionWidget.pcSetregion(this, (JpaRegion)JpaConverter.getInstance().convert(region, Region.class));
    }

    public String getRenderPosition() {
        return JpaRegionWidget.pcGetrenderPosition(this);
    }

    public void setRenderPosition(String renderPosition) {
        JpaRegionWidget.pcSetrenderPosition(this, renderPosition);
    }

    public int getRenderOrder() {
        return JpaRegionWidget.pcGetrenderOrder(this);
    }

    public void setRenderOrder(int renderOrder) {
        JpaRegionWidget.pcSetrenderOrder(this, renderOrder);
    }

    public boolean isCollapsed() {
        return JpaRegionWidget.pcGetcollapsed(this);
    }

    public void setCollapsed(boolean collapsed) {
        JpaRegionWidget.pcSetcollapsed(this, collapsed);
    }

    public List<RegionWidgetPreference> getPreferences() {
        return ConvertingListProxyFactory.createProxyList(RegionWidgetPreference.class, JpaRegionWidget.pcGetpreferences(this));
    }

    public void setPreferences(List<RegionWidgetPreference> preferences) {
        if (JpaRegionWidget.pcGetpreferences(this) == null) {
            JpaRegionWidget.pcSetpreferences(this, new ArrayList());
        }
        this.getPreferences().clear();
        if (preferences != null) {
            this.getPreferences().addAll(preferences);
        }
    }

    public boolean isLocked() {
        return JpaRegionWidget.pcGetlocked(this);
    }

    public void setLocked(boolean locked) {
        JpaRegionWidget.pcSetlocked(this, locked);
    }

    public boolean isHideChrome() {
        return JpaRegionWidget.pcGethideChrome(this);
    }

    public void setHideChrome(boolean hideChrome) {
        JpaRegionWidget.pcSethideChrome(this, hideChrome);
    }

    public Map<String, Object> getProperties() {
        return Maps.newHashMap();
    }

    public void setProperties(Map<String, Object> properties) {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JpaRegionWidget other = (JpaRegionWidget)obj;
        return JpaRegionWidget.pcGetentityId(this) == JpaRegionWidget.pcGetentityId(other) || JpaRegionWidget.pcGetentityId(this) != null && JpaRegionWidget.pcGetentityId(this).equals(JpaRegionWidget.pcGetentityId(other));
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + (JpaRegionWidget.pcGetentityId(this) != null ? JpaRegionWidget.pcGetentityId(this).hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JpaRegionWidget{");
        sb.append("entityId=");
        sb.append(JpaRegionWidget.pcGetentityId(this));
        if (JpaRegionWidget.pcGetwidgetId(this) != null) {
            sb.append(",widget=");
            sb.append(JpaRegionWidget.pcGetwidgetId(this));
        } else {
            sb.append(", Widget Null");
        }
        if (JpaRegionWidget.pcGetregion(this) != null) {
            sb.append(",regionId=");
            sb.append(JpaRegionWidget.pcGetregion(this).getEntityId());
        } else {
            sb.append(", Region Null");
        }
        sb.append("}");
        return sb.toString();
    }

    public int pcGetEnhancementContractVersion() {
        return 1468245;
    }

    static {
        pcFieldNames = new String[]{"collapsed", "entityId", "hideChrome", "locked", "preferences", "region", "renderOrder", "renderPosition", PARAM_WIDGET_ID};
        Class[] classArray = new Class[9];
        classArray[0] = Boolean.TYPE;
        Class clazz = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = JpaRegionWidget.class$("java.lang.Long"));
        classArray[1] = clazz;
        classArray[2] = Boolean.TYPE;
        classArray[3] = Boolean.TYPE;
        Class clazz2 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JpaRegionWidget.class$("java.util.List"));
        classArray[4] = clazz2;
        Class clazz3 = class$Lorg$apache$rave$portal$model$JpaRegion != null ? class$Lorg$apache$rave$portal$model$JpaRegion : (class$Lorg$apache$rave$portal$model$JpaRegion = JpaRegionWidget.class$("org.apache.rave.portal.model.JpaRegion"));
        classArray[5] = clazz3;
        classArray[6] = Integer.TYPE;
        Class clazz4 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaRegionWidget.class$("java.lang.String"));
        classArray[7] = clazz4;
        classArray[8] = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = JpaRegionWidget.class$("java.lang.Long"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 10, 26, 26, 26, 26};
        Class clazz5 = class$Lorg$apache$rave$portal$model$JpaRegionWidget != null ? class$Lorg$apache$rave$portal$model$JpaRegionWidget : (class$Lorg$apache$rave$portal$model$JpaRegionWidget = JpaRegionWidget.class$("org.apache.rave.portal.model.JpaRegionWidget"));
        PCRegistry.register((Class)clazz5, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JpaRegionWidget", (PersistenceCapable)new JpaRegionWidget());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.collapsed = false;
        this.entityId = null;
        this.hideChrome = false;
        this.locked = false;
        this.preferences = null;
        this.region = null;
        this.renderOrder = 0;
        this.renderPosition = null;
        this.widgetId = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JpaRegionWidget jpaRegionWidget = new JpaRegionWidget();
        if (bl) {
            jpaRegionWidget.pcClearFields();
        }
        jpaRegionWidget.pcStateManager = stateManager;
        jpaRegionWidget.pcCopyKeyFieldsFromObjectId(object);
        return jpaRegionWidget;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JpaRegionWidget jpaRegionWidget = new JpaRegionWidget();
        if (bl) {
            jpaRegionWidget.pcClearFields();
        }
        jpaRegionWidget.pcStateManager = stateManager;
        return jpaRegionWidget;
    }

    protected static int pcGetManagedFieldCount() {
        return 9;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.collapsed = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.entityId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.hideChrome = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.locked = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.preferences = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.region = (JpaRegion)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.renderOrder = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.renderPosition = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.widgetId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.collapsed);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.entityId);
                return;
            }
            case 2: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.hideChrome);
                return;
            }
            case 3: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.locked);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.preferences);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.region);
                return;
            }
            case 6: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.renderOrder);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.renderPosition);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.widgetId);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JpaRegionWidget jpaRegionWidget, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.collapsed = jpaRegionWidget.collapsed;
                return;
            }
            case 1: {
                this.entityId = jpaRegionWidget.entityId;
                return;
            }
            case 2: {
                this.hideChrome = jpaRegionWidget.hideChrome;
                return;
            }
            case 3: {
                this.locked = jpaRegionWidget.locked;
                return;
            }
            case 4: {
                this.preferences = jpaRegionWidget.preferences;
                return;
            }
            case 5: {
                this.region = jpaRegionWidget.region;
                return;
            }
            case 6: {
                this.renderOrder = jpaRegionWidget.renderOrder;
                return;
            }
            case 7: {
                this.renderPosition = jpaRegionWidget.renderPosition;
                return;
            }
            case 8: {
                this.widgetId = jpaRegionWidget.widgetId;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        JpaRegionWidget jpaRegionWidget = (JpaRegionWidget)object;
        if (jpaRegionWidget.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jpaRegionWidget, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(1 + pcInheritedFieldCount, (Object)new Long(longId.getId()));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this.entityId = new Long(longId.getId());
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$rave$portal$model$JpaRegionWidget != null ? class$Lorg$apache$rave$portal$model$JpaRegionWidget : (class$Lorg$apache$rave$portal$model$JpaRegionWidget = JpaRegionWidget.class$("org.apache.rave.portal.model.JpaRegionWidget"));
        return new LongId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$rave$portal$model$JpaRegionWidget != null ? class$Lorg$apache$rave$portal$model$JpaRegionWidget : (class$Lorg$apache$rave$portal$model$JpaRegionWidget = JpaRegionWidget.class$("org.apache.rave.portal.model.JpaRegionWidget"));
        return new LongId(clazz, this.entityId);
    }

    private static final boolean pcGetcollapsed(JpaRegionWidget jpaRegionWidget) {
        if (jpaRegionWidget.pcStateManager == null) {
            return jpaRegionWidget.collapsed;
        }
        int n = pcInheritedFieldCount + 0;
        jpaRegionWidget.pcStateManager.accessingField(n);
        return jpaRegionWidget.collapsed;
    }

    private static final void pcSetcollapsed(JpaRegionWidget jpaRegionWidget, boolean bl) {
        if (jpaRegionWidget.pcStateManager == null) {
            jpaRegionWidget.collapsed = bl;
            return;
        }
        jpaRegionWidget.pcStateManager.settingBooleanField((PersistenceCapable)jpaRegionWidget, pcInheritedFieldCount + 0, jpaRegionWidget.collapsed, bl, 0);
    }

    private static final Long pcGetentityId(JpaRegionWidget jpaRegionWidget) {
        if (jpaRegionWidget.pcStateManager == null) {
            return jpaRegionWidget.entityId;
        }
        int n = pcInheritedFieldCount + 1;
        jpaRegionWidget.pcStateManager.accessingField(n);
        return jpaRegionWidget.entityId;
    }

    private static final void pcSetentityId(JpaRegionWidget jpaRegionWidget, Long l) {
        if (jpaRegionWidget.pcStateManager == null) {
            jpaRegionWidget.entityId = l;
            return;
        }
        jpaRegionWidget.pcStateManager.settingObjectField((PersistenceCapable)jpaRegionWidget, pcInheritedFieldCount + 1, (Object)jpaRegionWidget.entityId, (Object)l, 0);
    }

    private static final boolean pcGethideChrome(JpaRegionWidget jpaRegionWidget) {
        if (jpaRegionWidget.pcStateManager == null) {
            return jpaRegionWidget.hideChrome;
        }
        int n = pcInheritedFieldCount + 2;
        jpaRegionWidget.pcStateManager.accessingField(n);
        return jpaRegionWidget.hideChrome;
    }

    private static final void pcSethideChrome(JpaRegionWidget jpaRegionWidget, boolean bl) {
        if (jpaRegionWidget.pcStateManager == null) {
            jpaRegionWidget.hideChrome = bl;
            return;
        }
        jpaRegionWidget.pcStateManager.settingBooleanField((PersistenceCapable)jpaRegionWidget, pcInheritedFieldCount + 2, jpaRegionWidget.hideChrome, bl, 0);
    }

    private static final boolean pcGetlocked(JpaRegionWidget jpaRegionWidget) {
        if (jpaRegionWidget.pcStateManager == null) {
            return jpaRegionWidget.locked;
        }
        int n = pcInheritedFieldCount + 3;
        jpaRegionWidget.pcStateManager.accessingField(n);
        return jpaRegionWidget.locked;
    }

    private static final void pcSetlocked(JpaRegionWidget jpaRegionWidget, boolean bl) {
        if (jpaRegionWidget.pcStateManager == null) {
            jpaRegionWidget.locked = bl;
            return;
        }
        jpaRegionWidget.pcStateManager.settingBooleanField((PersistenceCapable)jpaRegionWidget, pcInheritedFieldCount + 3, jpaRegionWidget.locked, bl, 0);
    }

    private static final List pcGetpreferences(JpaRegionWidget jpaRegionWidget) {
        if (jpaRegionWidget.pcStateManager == null) {
            return jpaRegionWidget.preferences;
        }
        int n = pcInheritedFieldCount + 4;
        jpaRegionWidget.pcStateManager.accessingField(n);
        return jpaRegionWidget.preferences;
    }

    private static final void pcSetpreferences(JpaRegionWidget jpaRegionWidget, List list) {
        if (jpaRegionWidget.pcStateManager == null) {
            jpaRegionWidget.preferences = list;
            return;
        }
        jpaRegionWidget.pcStateManager.settingObjectField((PersistenceCapable)jpaRegionWidget, pcInheritedFieldCount + 4, jpaRegionWidget.preferences, (Object)list, 0);
    }

    private static final JpaRegion pcGetregion(JpaRegionWidget jpaRegionWidget) {
        if (jpaRegionWidget.pcStateManager == null) {
            return jpaRegionWidget.region;
        }
        int n = pcInheritedFieldCount + 5;
        jpaRegionWidget.pcStateManager.accessingField(n);
        return jpaRegionWidget.region;
    }

    private static final void pcSetregion(JpaRegionWidget jpaRegionWidget, JpaRegion jpaRegion) {
        if (jpaRegionWidget.pcStateManager == null) {
            jpaRegionWidget.region = jpaRegion;
            return;
        }
        jpaRegionWidget.pcStateManager.settingObjectField((PersistenceCapable)jpaRegionWidget, pcInheritedFieldCount + 5, (Object)jpaRegionWidget.region, (Object)jpaRegion, 0);
    }

    private static final int pcGetrenderOrder(JpaRegionWidget jpaRegionWidget) {
        if (jpaRegionWidget.pcStateManager == null) {
            return jpaRegionWidget.renderOrder;
        }
        int n = pcInheritedFieldCount + 6;
        jpaRegionWidget.pcStateManager.accessingField(n);
        return jpaRegionWidget.renderOrder;
    }

    private static final void pcSetrenderOrder(JpaRegionWidget jpaRegionWidget, int n) {
        if (jpaRegionWidget.pcStateManager == null) {
            jpaRegionWidget.renderOrder = n;
            return;
        }
        jpaRegionWidget.pcStateManager.settingIntField((PersistenceCapable)jpaRegionWidget, pcInheritedFieldCount + 6, jpaRegionWidget.renderOrder, n, 0);
    }

    private static final String pcGetrenderPosition(JpaRegionWidget jpaRegionWidget) {
        if (jpaRegionWidget.pcStateManager == null) {
            return jpaRegionWidget.renderPosition;
        }
        int n = pcInheritedFieldCount + 7;
        jpaRegionWidget.pcStateManager.accessingField(n);
        return jpaRegionWidget.renderPosition;
    }

    private static final void pcSetrenderPosition(JpaRegionWidget jpaRegionWidget, String string) {
        if (jpaRegionWidget.pcStateManager == null) {
            jpaRegionWidget.renderPosition = string;
            return;
        }
        jpaRegionWidget.pcStateManager.settingStringField((PersistenceCapable)jpaRegionWidget, pcInheritedFieldCount + 7, jpaRegionWidget.renderPosition, string, 0);
    }

    private static final Long pcGetwidgetId(JpaRegionWidget jpaRegionWidget) {
        if (jpaRegionWidget.pcStateManager == null) {
            return jpaRegionWidget.widgetId;
        }
        int n = pcInheritedFieldCount + 8;
        jpaRegionWidget.pcStateManager.accessingField(n);
        return jpaRegionWidget.widgetId;
    }

    private static final void pcSetwidgetId(JpaRegionWidget jpaRegionWidget, Long l) {
        if (jpaRegionWidget.pcStateManager == null) {
            jpaRegionWidget.widgetId = l;
            return;
        }
        jpaRegionWidget.pcStateManager.settingObjectField((PersistenceCapable)jpaRegionWidget, pcInheritedFieldCount + 8, (Object)jpaRegionWidget.widgetId, (Object)l, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.entityId != null) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        if (this.pcGetDetachedState() == null) {
            return Boolean.FALSE;
        }
        return null;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

