/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PreRemove;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.rave.model.Authority;
import org.apache.rave.model.PageLayout;
import org.apache.rave.model.Person;
import org.apache.rave.model.User;
import org.apache.rave.portal.model.BasicEntity;
import org.apache.rave.portal.model.JpaAuthority;
import org.apache.rave.portal.model.JpaPageLayout;
import org.apache.rave.portal.model.JpaPerson;
import org.apache.rave.portal.model.conversion.JpaConverter;
import org.apache.rave.portal.model.impl.PersonImpl;
import org.apache.rave.util.CollectionUtils;
import org.springframework.security.core.GrantedAuthority;

@Entity
@Access(value=AccessType.FIELD)
@NamedQueries(value={@NamedQuery(name="User.getByUsername", query="select u from JpaUser u where u.username = :username"), @NamedQuery(name="User.getByUserEmail", query="select u from JpaUser u where u.email = :email"), @NamedQuery(name="User.getByOpenId", query="select u from JpaUser u where u.openId = :openId"), @NamedQuery(name="User.getAll", query="select u from JpaUser u order by u.username asc"), @NamedQuery(name="User.getByForgotPasswordHash", query="select u from JpaUser u where u.forgotPasswordHash = :forgotPasswordHash"), @NamedQuery(name="User.countAll", query="select count(u) from JpaUser u"), @NamedQuery(name="User.findByUsernameOrEmail", query="select u from JpaUser u where lower(u.username) like :searchTerm or lower(u.email) like :searchTerm order by u.username asc"), @NamedQuery(name="User.countFindByUsernameOrEmail", query="select count(u) from JpaUser u where lower(u.username) like :searchTerm or lower(u.email) like :searchTerm"), @NamedQuery(name="User.getAllForAddedWidget", query="select distinct(u) from JpaUser u, JpaRegionWidget rw where rw.region.page.ownerId = CONCAT(u.entityId,'') and rw.widgetId = :widgetId")})
@DiscriminatorValue(value="User")
public class JpaUser
extends JpaPerson
implements BasicEntity,
Serializable,
User,
PersistenceCapable {
    private static final long serialVersionUID = 1L;
    public static final String USER_GET_BY_USERNAME = "User.getByUsername";
    public static final String USER_GET_BY_USER_EMAIL = "User.getByUserEmail";
    public static final String USER_GET_BY_OPENID = "User.getByOpenId";
    public static final String USER_GET_ALL = "User.getAll";
    public static final String USER_COUNT_ALL = "User.countAll";
    public static final String USER_FIND_BY_USERNAME_OR_EMAIL = "User.findByUsernameOrEmail";
    public static final String USER_COUNT_FIND_BY_USERNAME_OR_EMAIL = "User.countFindByUsernameOrEmail";
    public static final String USER_GET_COMMENTERS = "User.getCommenters";
    public static final String USER_GET_ALL_FOR_ADDED_WIDGET = "User.getAllForAddedWidget";
    public static final String USER_GET_BY_FORGOT_PASSWORD_HASH = "User.getByForgotPasswordHash";
    public static final String PARAM_USERNAME = "username";
    public static final String PARAM_FORGOT_PASSWORD_HASH = "forgotPasswordHash";
    public static final String PARAM_EMAIL = "email";
    public static final String PARAM_OPENID = "openId";
    public static final String PARAM_SEARCHTERM = "searchTerm";
    public static final String PARAM_WIDGET_ID = "widgetId";
    @Basic
    @Column(name="password")
    private String password;
    @Basic
    @Column(name="expired")
    private boolean expired;
    @Basic
    @Column(name="locked")
    private boolean locked;
    @Basic
    @Column(name="enabled")
    private boolean enabled;
    @Basic
    @Column(name="openid")
    private String openId;
    @Basic
    @Column(name="forgotPasswordHash", unique=true)
    private String forgotPasswordHash;
    @Basic
    @Column(name="password_hash_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date forgotPasswordTime;
    @ManyToOne
    @JoinColumn(name="default_page_layout_id")
    private JpaPageLayout defaultPageLayout;
    @Transient
    private String confirmPassword;
    @Transient
    private String defaultPageLayoutCode;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="user_authorities", joinColumns={@JoinColumn(name="user_id", referencedColumnName="entity_id")}, inverseJoinColumns={@JoinColumn(name="authority_id", referencedColumnName="entity_id")})
    private Collection<JpaAuthority> authorities;
    private static int pcInheritedFieldCount = JpaPerson.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$rave$portal$model$JpaPerson;
    static /* synthetic */ Class class$Ljava$util$Collection;
    static /* synthetic */ Class class$Lorg$apache$rave$portal$model$JpaPageLayout;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Lorg$apache$rave$portal$model$JpaUser;

    public JpaUser() {
        this(null, null);
    }

    public JpaUser(Long entityId) {
        this(entityId, null);
    }

    public JpaUser(Long entityId, String username) {
        this.entityId = entityId;
        this.username = username;
        this.authorities = new ArrayList<JpaAuthority>();
    }

    @Override
    public Long getEntityId() {
        return JpaPerson.pcGetentityId(this);
    }

    @Override
    public void setEntityId(Long entityId) {
        JpaPerson.pcSetentityId(this, entityId);
    }

    public Collection<GrantedAuthority> getAuthorities() {
        return CollectionUtils.toBaseTypedCollection((Collection)JpaUser.pcGetauthorities(this));
    }

    public void addAuthority(Authority authority) {
        JpaAuthority converted = (JpaAuthority)JpaConverter.getInstance().convert(authority, Authority.class);
        if (!JpaUser.pcGetauthorities(this).contains(converted)) {
            JpaUser.pcGetauthorities(this).add(converted);
        }
        if (!authority.getUsers().contains(this)) {
            authority.addUser((User)this);
        }
    }

    public void removeAuthority(Authority authority) {
        JpaAuthority converted = (JpaAuthority)JpaConverter.getInstance().convert(authority, Authority.class);
        if (JpaUser.pcGetauthorities(this).contains(converted)) {
            JpaUser.pcGetauthorities(this).remove(converted);
        }
    }

    public void setAuthorities(Collection<Authority> newAuthorities) {
        this.getAuthorities().clear();
        if (newAuthorities != null) {
            this.getAuthorities().addAll(newAuthorities);
        }
    }

    public String getPassword() {
        return JpaUser.pcGetpassword(this);
    }

    public void setPassword(String password) {
        JpaUser.pcSetpassword(this, password);
    }

    @Override
    public String getUsername() {
        return JpaPerson.pcGetusername(this);
    }

    @Override
    public void setUsername(String username) {
        JpaPerson.pcSetusername(this, username);
    }

    public boolean isAccountNonLocked() {
        return !JpaUser.pcGetlocked(this);
    }

    public boolean isLocked() {
        return JpaUser.pcGetlocked(this);
    }

    public void setLocked(boolean locked) {
        JpaUser.pcSetlocked(this, locked);
    }

    public boolean isCredentialsNonExpired() {
        return !JpaUser.pcGetexpired(this);
    }

    public boolean isAccountNonExpired() {
        return this.isCredentialsNonExpired();
    }

    public boolean isExpired() {
        return JpaUser.pcGetexpired(this);
    }

    public void setExpired(boolean expired) {
        JpaUser.pcSetexpired(this, expired);
    }

    public boolean isEnabled() {
        return JpaUser.pcGetenabled(this);
    }

    public void setEnabled(boolean enabled) {
        JpaUser.pcSetenabled(this, enabled);
    }

    @Override
    public String getEmail() {
        return JpaPerson.pcGetemail(this);
    }

    @Override
    public void setEmail(String email) {
        JpaPerson.pcSetemail(this, email);
    }

    public String getOpenId() {
        return JpaUser.pcGetopenId(this);
    }

    public void setOpenId(String openId) {
        JpaUser.pcSetopenId(this, openId);
    }

    public String getForgotPasswordHash() {
        return JpaUser.pcGetforgotPasswordHash(this);
    }

    public void setForgotPasswordHash(String forgotPasswordHash) {
        JpaUser.pcSetforgotPasswordHash(this, forgotPasswordHash);
    }

    public Date getForgotPasswordTime() {
        return JpaUser.pcGetforgotPasswordTime(this);
    }

    public void setForgotPasswordTime(Date forgotPasswordTime) {
        JpaUser.pcSetforgotPasswordTime(this, forgotPasswordTime);
    }

    public PageLayout getDefaultPageLayout() {
        return JpaUser.pcGetdefaultPageLayout(this);
    }

    public void setDefaultPageLayout(PageLayout defaultPageLayout) {
        JpaUser.pcSetdefaultPageLayout(this, (JpaPageLayout)JpaConverter.getInstance().convert(defaultPageLayout, PageLayout.class));
    }

    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    @PreRemove
    public void preRemove() {
        for (JpaAuthority authority : JpaUser.pcGetauthorities(this)) {
            authority.removeUser(this);
        }
        JpaUser.pcSetauthorities(this, Collections.emptyList());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        JpaUser other = (JpaUser)obj;
        return JpaPerson.pcGetentityId(this) == JpaPerson.pcGetentityId(other) || JpaPerson.pcGetentityId(this) != null && JpaPerson.pcGetentityId(this).equals(JpaPerson.pcGetentityId(other));
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (JpaPerson.pcGetentityId(this) != null ? JpaPerson.pcGetentityId(this).hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("User");
        sb.append("{entityId=").append(JpaPerson.pcGetentityId(this));
        sb.append(", username='").append(JpaPerson.pcGetusername(this)).append('\'');
        sb.append(", expired=").append(JpaUser.pcGetexpired(this));
        sb.append(", locked=").append(JpaUser.pcGetlocked(this));
        sb.append(", enabled=").append(JpaUser.pcGetenabled(this));
        sb.append(", email='").append(JpaPerson.pcGetemail(this)).append('\'');
        sb.append(", openId='").append(JpaUser.pcGetopenId(this)).append('\'');
        sb.append(", authorities=[");
        boolean first = true;
        for (JpaAuthority a : JpaUser.pcGetauthorities(this)) {
            if (!first) {
                sb.append(',');
            }
            sb.append('\'').append(a.getAuthority()).append('\'');
            first = false;
        }
        sb.append(']');
        sb.append('}');
        return sb.toString();
    }

    public Person toPerson() {
        PersonImpl p = new PersonImpl();
        p.setAboutMe(this.getAboutMe());
        p.setAdditionalName(this.getAdditionalName());
        p.setAddresses(this.getAddresses());
        p.setDisplayName(this.getDisplayName());
        p.setEmail(this.getEmail());
        p.setFamilyName(this.getFamilyName());
        p.setGivenName(this.getGivenName());
        p.setHonorificPrefix(this.getHonorificPrefix());
        p.setHonorificSuffix(this.getHonorificSuffix());
        p.setOrganizations(this.getOrganizations());
        p.setPreferredName(this.getPreferredName());
        p.setProperties(this.getProperties());
        p.setStatus(this.getStatus());
        p.setUsername(this.getUsername());
        return p;
    }

    @Override
    public String getId() {
        return this.getEntityId() == null ? null : this.getEntityId().toString();
    }

    public String getDefaultPageLayoutCode() {
        return this.defaultPageLayoutCode;
    }

    public void setDefaultPageLayoutCode(String defaultPageLayoutCode) {
        this.defaultPageLayoutCode = defaultPageLayoutCode;
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1468245;
    }

    static {
        Class clazz = class$Lorg$apache$rave$portal$model$JpaPerson != null ? class$Lorg$apache$rave$portal$model$JpaPerson : (class$Lorg$apache$rave$portal$model$JpaPerson = JpaUser.class$("org.apache.rave.portal.model.JpaPerson"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"authorities", "defaultPageLayout", "enabled", "expired", PARAM_FORGOT_PASSWORD_HASH, "forgotPasswordTime", "locked", PARAM_OPENID, "password"};
        Class[] classArray = new Class[9];
        Class clazz2 = class$Ljava$util$Collection != null ? class$Ljava$util$Collection : (class$Ljava$util$Collection = JpaUser.class$("java.util.Collection"));
        classArray[0] = clazz2;
        Class clazz3 = class$Lorg$apache$rave$portal$model$JpaPageLayout != null ? class$Lorg$apache$rave$portal$model$JpaPageLayout : (class$Lorg$apache$rave$portal$model$JpaPageLayout = JpaUser.class$("org.apache.rave.portal.model.JpaPageLayout"));
        classArray[1] = clazz3;
        classArray[2] = Boolean.TYPE;
        classArray[3] = Boolean.TYPE;
        Class clazz4 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaUser.class$("java.lang.String"));
        classArray[4] = clazz4;
        Class clazz5 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = JpaUser.class$("java.util.Date"));
        classArray[5] = clazz5;
        classArray[6] = Boolean.TYPE;
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaUser.class$("java.lang.String"));
        classArray[8] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaUser.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{10, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz6 = class$Lorg$apache$rave$portal$model$JpaUser != null ? class$Lorg$apache$rave$portal$model$JpaUser : (class$Lorg$apache$rave$portal$model$JpaUser = JpaUser.class$("org.apache.rave.portal.model.JpaUser"));
        PCRegistry.register((Class)clazz6, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JpaUser", (PersistenceCapable)new JpaUser());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.authorities = null;
        this.defaultPageLayout = null;
        this.enabled = false;
        this.expired = false;
        this.forgotPasswordHash = null;
        this.forgotPasswordTime = null;
        this.locked = false;
        this.openId = null;
        this.password = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JpaUser jpaUser = new JpaUser();
        if (bl) {
            jpaUser.pcClearFields();
        }
        jpaUser.pcStateManager = stateManager;
        jpaUser.pcCopyKeyFieldsFromObjectId(object);
        return jpaUser;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JpaUser jpaUser = new JpaUser();
        if (bl) {
            jpaUser.pcClearFields();
        }
        jpaUser.pcStateManager = stateManager;
        return jpaUser;
    }

    protected static int pcGetManagedFieldCount() {
        return 9 + JpaPerson.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.authorities = (Collection)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.defaultPageLayout = (JpaPageLayout)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.enabled = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.expired = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.forgotPasswordHash = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.forgotPasswordTime = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.locked = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.openId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.password = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.authorities);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.defaultPageLayout);
                return;
            }
            case 2: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.enabled);
                return;
            }
            case 3: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.expired);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.forgotPasswordHash);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.forgotPasswordTime);
                return;
            }
            case 6: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.locked);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.openId);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.password);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JpaUser jpaUser, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jpaUser, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.authorities = jpaUser.authorities;
                return;
            }
            case 1: {
                this.defaultPageLayout = jpaUser.defaultPageLayout;
                return;
            }
            case 2: {
                this.enabled = jpaUser.enabled;
                return;
            }
            case 3: {
                this.expired = jpaUser.expired;
                return;
            }
            case 4: {
                this.forgotPasswordHash = jpaUser.forgotPasswordHash;
                return;
            }
            case 5: {
                this.forgotPasswordTime = jpaUser.forgotPasswordTime;
                return;
            }
            case 6: {
                this.locked = jpaUser.locked;
                return;
            }
            case 7: {
                this.openId = jpaUser.openId;
                return;
            }
            case 8: {
                this.password = jpaUser.password;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JpaUser jpaUser = (JpaUser)object;
        if (jpaUser.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jpaUser, nArray[n]);
            ++n;
        }
    }

    private static final Collection pcGetauthorities(JpaUser jpaUser) {
        if (jpaUser.pcStateManager == null) {
            return jpaUser.authorities;
        }
        int n = pcInheritedFieldCount + 0;
        jpaUser.pcStateManager.accessingField(n);
        return jpaUser.authorities;
    }

    private static final void pcSetauthorities(JpaUser jpaUser, Collection collection) {
        if (jpaUser.pcStateManager == null) {
            jpaUser.authorities = collection;
            return;
        }
        jpaUser.pcStateManager.settingObjectField((PersistenceCapable)jpaUser, pcInheritedFieldCount + 0, jpaUser.authorities, (Object)collection, 0);
    }

    private static final JpaPageLayout pcGetdefaultPageLayout(JpaUser jpaUser) {
        if (jpaUser.pcStateManager == null) {
            return jpaUser.defaultPageLayout;
        }
        int n = pcInheritedFieldCount + 1;
        jpaUser.pcStateManager.accessingField(n);
        return jpaUser.defaultPageLayout;
    }

    private static final void pcSetdefaultPageLayout(JpaUser jpaUser, JpaPageLayout jpaPageLayout) {
        if (jpaUser.pcStateManager == null) {
            jpaUser.defaultPageLayout = jpaPageLayout;
            return;
        }
        jpaUser.pcStateManager.settingObjectField((PersistenceCapable)jpaUser, pcInheritedFieldCount + 1, (Object)jpaUser.defaultPageLayout, (Object)jpaPageLayout, 0);
    }

    private static final boolean pcGetenabled(JpaUser jpaUser) {
        if (jpaUser.pcStateManager == null) {
            return jpaUser.enabled;
        }
        int n = pcInheritedFieldCount + 2;
        jpaUser.pcStateManager.accessingField(n);
        return jpaUser.enabled;
    }

    private static final void pcSetenabled(JpaUser jpaUser, boolean bl) {
        if (jpaUser.pcStateManager == null) {
            jpaUser.enabled = bl;
            return;
        }
        jpaUser.pcStateManager.settingBooleanField((PersistenceCapable)jpaUser, pcInheritedFieldCount + 2, jpaUser.enabled, bl, 0);
    }

    private static final boolean pcGetexpired(JpaUser jpaUser) {
        if (jpaUser.pcStateManager == null) {
            return jpaUser.expired;
        }
        int n = pcInheritedFieldCount + 3;
        jpaUser.pcStateManager.accessingField(n);
        return jpaUser.expired;
    }

    private static final void pcSetexpired(JpaUser jpaUser, boolean bl) {
        if (jpaUser.pcStateManager == null) {
            jpaUser.expired = bl;
            return;
        }
        jpaUser.pcStateManager.settingBooleanField((PersistenceCapable)jpaUser, pcInheritedFieldCount + 3, jpaUser.expired, bl, 0);
    }

    private static final String pcGetforgotPasswordHash(JpaUser jpaUser) {
        if (jpaUser.pcStateManager == null) {
            return jpaUser.forgotPasswordHash;
        }
        int n = pcInheritedFieldCount + 4;
        jpaUser.pcStateManager.accessingField(n);
        return jpaUser.forgotPasswordHash;
    }

    private static final void pcSetforgotPasswordHash(JpaUser jpaUser, String string) {
        if (jpaUser.pcStateManager == null) {
            jpaUser.forgotPasswordHash = string;
            return;
        }
        jpaUser.pcStateManager.settingStringField((PersistenceCapable)jpaUser, pcInheritedFieldCount + 4, jpaUser.forgotPasswordHash, string, 0);
    }

    private static final Date pcGetforgotPasswordTime(JpaUser jpaUser) {
        if (jpaUser.pcStateManager == null) {
            return jpaUser.forgotPasswordTime;
        }
        int n = pcInheritedFieldCount + 5;
        jpaUser.pcStateManager.accessingField(n);
        return jpaUser.forgotPasswordTime;
    }

    private static final void pcSetforgotPasswordTime(JpaUser jpaUser, Date date) {
        if (jpaUser.pcStateManager == null) {
            jpaUser.forgotPasswordTime = date;
            return;
        }
        jpaUser.pcStateManager.settingObjectField((PersistenceCapable)jpaUser, pcInheritedFieldCount + 5, (Object)jpaUser.forgotPasswordTime, (Object)date, 0);
    }

    private static final boolean pcGetlocked(JpaUser jpaUser) {
        if (jpaUser.pcStateManager == null) {
            return jpaUser.locked;
        }
        int n = pcInheritedFieldCount + 6;
        jpaUser.pcStateManager.accessingField(n);
        return jpaUser.locked;
    }

    private static final void pcSetlocked(JpaUser jpaUser, boolean bl) {
        if (jpaUser.pcStateManager == null) {
            jpaUser.locked = bl;
            return;
        }
        jpaUser.pcStateManager.settingBooleanField((PersistenceCapable)jpaUser, pcInheritedFieldCount + 6, jpaUser.locked, bl, 0);
    }

    private static final String pcGetopenId(JpaUser jpaUser) {
        if (jpaUser.pcStateManager == null) {
            return jpaUser.openId;
        }
        int n = pcInheritedFieldCount + 7;
        jpaUser.pcStateManager.accessingField(n);
        return jpaUser.openId;
    }

    private static final void pcSetopenId(JpaUser jpaUser, String string) {
        if (jpaUser.pcStateManager == null) {
            jpaUser.openId = string;
            return;
        }
        jpaUser.pcStateManager.settingStringField((PersistenceCapable)jpaUser, pcInheritedFieldCount + 7, jpaUser.openId, string, 0);
    }

    private static final String pcGetpassword(JpaUser jpaUser) {
        if (jpaUser.pcStateManager == null) {
            return jpaUser.password;
        }
        int n = pcInheritedFieldCount + 8;
        jpaUser.pcStateManager.accessingField(n);
        return jpaUser.password;
    }

    private static final void pcSetpassword(JpaUser jpaUser, String string) {
        if (jpaUser.pcStateManager == null) {
            jpaUser.password = string;
            return;
        }
        jpaUser.pcStateManager.settingStringField((PersistenceCapable)jpaUser, pcInheritedFieldCount + 8, jpaUser.password, string, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

