/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.rave.model.Address;
import org.apache.rave.model.ModelConverter;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaAddress;
import org.springframework.stereotype.Component;

@Component
public class JpaAddressConverter
implements ModelConverter<Address, JpaAddress> {
    @PersistenceContext
    private EntityManager manager;

    public Class<Address> getSourceType() {
        return Address.class;
    }

    public JpaAddress convert(Address source) {
        return source instanceof JpaAddress ? (JpaAddress)source : this.createEntity(source);
    }

    private JpaAddress createEntity(Address source) {
        JpaAddress converted = null;
        if (source != null) {
            TypedQuery query = this.manager.createNamedQuery("findByStreetCityCountry", JpaAddress.class);
            query.setParameter("street", (Object)source.getStreetAddress());
            query.setParameter("city", (Object)source.getLocality());
            query.setParameter("country", (Object)source.getCountry());
            converted = (JpaAddress)JpaUtil.getSingleResult(query.getResultList());
            if (converted == null) {
                converted = new JpaAddress();
            }
            this.updateProperties(source, converted);
        }
        return converted;
    }

    private void updateProperties(Address source, JpaAddress converted) {
        converted.setCountry(source.getCountry());
        converted.setLatitude(source.getLatitude());
        converted.setLongitude(source.getLongitude());
        converted.setLocality(source.getLocality());
        converted.setPostalCode(source.getPostalCode());
        converted.setRegion(source.getRegion());
        converted.setStreetAddress(source.getStreetAddress());
        converted.setQualifier(source.getQualifier());
        converted.setFormatted(source.getFormatted());
        converted.setPrimary(source.getPrimary());
    }
}

