/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.rave.model.ApplicationData;
import org.apache.rave.model.ModelConverter;
import org.apache.rave.portal.model.JpaApplicationData;
import org.springframework.stereotype.Component;

@Component
public class JpaApplicationDataConverter
implements ModelConverter<ApplicationData, JpaApplicationData> {
    @PersistenceContext
    private EntityManager manager;

    public Class<ApplicationData> getSourceType() {
        return ApplicationData.class;
    }

    public JpaApplicationData convert(ApplicationData source) {
        return source instanceof JpaApplicationData ? (JpaApplicationData)source : this.createEntity(source);
    }

    private JpaApplicationData createEntity(ApplicationData source) {
        JpaApplicationData converted = null;
        if (source != null) {
            JpaApplicationData jpaApplicationData = converted = source.getId() == null ? new JpaApplicationData() : (JpaApplicationData)this.manager.find(JpaApplicationData.class, (Object)Long.parseLong(source.getId()));
            if (converted == null) {
                converted = new JpaApplicationData();
            }
            this.updateProperties(source, converted);
        }
        return converted;
    }

    private void updateProperties(ApplicationData source, JpaApplicationData converted) {
        converted.setId(source.getId());
        converted.setAppUrl(source.getAppUrl());
        converted.setUserId(source.getUserId());
        converted.setData(source.getData());
    }
}

