/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.rave.model.Authority;
import org.apache.rave.model.ModelConverter;
import org.apache.rave.model.User;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaAuthority;
import org.springframework.stereotype.Component;

@Component
public class JpaAuthorityConverter
implements ModelConverter<Authority, JpaAuthority> {
    @PersistenceContext
    private EntityManager manager;

    public Class<Authority> getSourceType() {
        return Authority.class;
    }

    public JpaAuthority convert(Authority source) {
        return source instanceof JpaAuthority ? (JpaAuthority)source : this.createEntity(source);
    }

    private JpaAuthority createEntity(Authority source) {
        JpaAuthority converted = null;
        if (source != null) {
            TypedQuery query = this.manager.createNamedQuery("Authority.GetByAuthorityName", JpaAuthority.class);
            query.setParameter("authority", (Object)source.getAuthority());
            converted = (JpaAuthority)JpaUtil.getSingleResult(query.getResultList());
            if (converted == null) {
                converted = new JpaAuthority();
                this.updateProperties(source, converted);
            }
        }
        return converted;
    }

    private void updateProperties(Authority source, JpaAuthority converted) {
        converted.setDefaultForNewUser(source.isDefaultForNewUser());
        converted.setAuthority(source.getAuthority());
        for (User user : source.getUsers()) {
            converted.addUser(user);
        }
    }
}

