/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.rave.model.Category;
import org.apache.rave.model.ModelConverter;
import org.apache.rave.portal.model.JpaCategory;
import org.springframework.stereotype.Component;

@Component
public class JpaCategoryConverter
implements ModelConverter<Category, JpaCategory> {
    @PersistenceContext
    private EntityManager manager;

    public Class<Category> getSourceType() {
        return Category.class;
    }

    public JpaCategory convert(Category source) {
        return source instanceof JpaCategory ? (JpaCategory)source : this.createEntity(source);
    }

    private JpaCategory createEntity(Category source) {
        JpaCategory converted = null;
        if (source != null) {
            JpaCategory jpaCategory = converted = source.getId() == null ? new JpaCategory() : (JpaCategory)this.manager.find(JpaCategory.class, (Object)Long.parseLong(source.getId()));
            if (converted == null) {
                converted = new JpaCategory();
            }
            this.updateProperties(source, converted);
        }
        return converted;
    }

    private void updateProperties(Category source, JpaCategory converted) {
        converted.setId(source.getId());
        converted.setCreatedDate(source.getCreatedDate());
        converted.setCreatedUserId(source.getCreatedUserId());
        converted.setLastModifiedDate(source.getLastModifiedDate());
        converted.setLastModifiedUserId(source.getLastModifiedUserId());
        converted.setText(source.getText());
        converted.setWidgets(source.getWidgets());
    }
}

