/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rave.model.ModelConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JpaConverter {
    private static JpaConverter instance;
    Map<Class<?>, ModelConverter> converterMap = new HashMap();

    @Autowired
    JpaConverter(List<ModelConverter> converters) {
        for (ModelConverter converter : converters) {
            this.converterMap.put(converter.getSourceType(), converter);
        }
        instance = this;
    }

    public <S, T> T convert(S source, Class<S> clazz) {
        if (this.converterMap.containsKey(clazz)) {
            return (T)this.converterMap.get(clazz).convert(source);
        }
        throw new IllegalArgumentException("No ModelConverter found for type " + clazz);
    }

    public <S, T> ModelConverter<S, T> getConverter(Class<S> clazz) {
        return this.converterMap.get(clazz);
    }

    protected static boolean isInstanceSet() {
        return instance != null;
    }

    public static JpaConverter getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Conversion factory not set by the Spring context");
        }
        return instance;
    }
}

