/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.rave.model.Group;
import org.apache.rave.model.ModelConverter;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaGroup;
import org.springframework.stereotype.Component;

@Component
public class JpaGroupConverter
implements ModelConverter<Group, JpaGroup> {
    @PersistenceContext
    private EntityManager manager;

    public Class<Group> getSourceType() {
        return Group.class;
    }

    public JpaGroup convert(Group source) {
        return source instanceof JpaGroup ? (JpaGroup)source : this.createEntity(source);
    }

    private JpaGroup createEntity(Group source) {
        JpaGroup converted = null;
        if (source != null) {
            TypedQuery query = this.manager.createNamedQuery("Group.findByTitle", JpaGroup.class);
            query.setParameter("title", (Object)source.getTitle());
            converted = (JpaGroup)JpaUtil.getSingleResult(query.getResultList());
            if (converted == null) {
                converted = new JpaGroup();
            }
            this.updateProperties(source, converted);
        }
        return converted;
    }

    private void updateProperties(Group source, JpaGroup converted) {
        converted.setDescription(source.getDescription());
        converted.setTitle(source.getTitle());
        converted.setOwnerId(source.getOwnerId());
        converted.setMemberIds(source.getMemberIds());
    }
}

