/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.rave.model.ModelConverter;
import org.apache.rave.model.OAuthConsumerStore;
import org.apache.rave.portal.model.JpaOAuthConsumerStore;
import org.springframework.stereotype.Component;

@Component
public class JpaOAuthConsumerStoreConverter
implements ModelConverter<OAuthConsumerStore, JpaOAuthConsumerStore> {
    @PersistenceContext
    private EntityManager manager;

    public Class<OAuthConsumerStore> getSourceType() {
        return OAuthConsumerStore.class;
    }

    public JpaOAuthConsumerStore convert(OAuthConsumerStore source) {
        return source instanceof JpaOAuthConsumerStore ? (JpaOAuthConsumerStore)source : this.createEntity(source);
    }

    private JpaOAuthConsumerStore createEntity(OAuthConsumerStore source) {
        JpaOAuthConsumerStore converted = null;
        if (source != null) {
            JpaOAuthConsumerStore jpaOAuthConsumerStore = converted = source.getId() == null ? new JpaOAuthConsumerStore() : (JpaOAuthConsumerStore)this.manager.find(JpaOAuthConsumerStore.class, (Object)Long.parseLong(source.getId()));
            if (converted == null) {
                converted = new JpaOAuthConsumerStore();
            }
            this.updateProperties(source, converted);
        }
        return converted;
    }

    private void updateProperties(OAuthConsumerStore source, JpaOAuthConsumerStore converted) {
        converted.setId(source.getId());
        converted.setServiceName(source.getServiceName());
        converted.setCallbackUrl(source.getCallbackUrl());
        converted.setConsumerKey(source.getConsumerKey());
        converted.setConsumerSecret(source.getConsumerSecret());
        converted.setGadgetUri(source.getGadgetUri());
        converted.setKeyName(source.getKeyName());
        converted.setKeyType(source.getKeyType());
    }
}

