/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.rave.model.ModelConverter;
import org.apache.rave.model.Organization;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaOrganization;
import org.springframework.stereotype.Component;

@Component
public class JpaOrganizationConverter
implements ModelConverter<Organization, JpaOrganization> {
    @PersistenceContext
    private EntityManager manager;

    public Class<Organization> getSourceType() {
        return Organization.class;
    }

    public JpaOrganization convert(Organization source) {
        return source instanceof JpaOrganization ? (JpaOrganization)source : this.createEntity(source);
    }

    private JpaOrganization createEntity(Organization source) {
        JpaOrganization converted = null;
        if (source != null) {
            TypedQuery query = this.manager.createNamedQuery("findByName", JpaOrganization.class);
            query.setParameter("name", (Object)source.getName());
            converted = (JpaOrganization)JpaUtil.getSingleResult(query.getResultList());
            if (converted == null) {
                converted = new JpaOrganization();
            }
            this.updateProperties(source, converted);
        }
        return converted;
    }

    private void updateProperties(Organization source, JpaOrganization converted) {
        converted.setAddress(source.getAddress());
        converted.setDescription(source.getDescription());
        converted.setEndDate(source.getEndDate());
        converted.setField(source.getField());
        converted.setName(source.getName());
        converted.setStartDate(source.getStartDate());
        converted.setSubField(source.getSubField());
        converted.setTitle(source.getTitle());
        converted.setWebpage(source.getWebpage());
        converted.setQualifier(source.getQualifier());
        converted.setPrimary(source.getPrimary());
    }
}

