/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.rave.model.ModelConverter;
import org.apache.rave.model.PageLayout;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaPageLayout;
import org.springframework.stereotype.Component;

@Component
public class JpaPageLayoutConverter
implements ModelConverter<PageLayout, JpaPageLayout> {
    @PersistenceContext
    private EntityManager manager;

    public Class<PageLayout> getSourceType() {
        return PageLayout.class;
    }

    public JpaPageLayout convert(PageLayout source) {
        return source instanceof JpaPageLayout ? (JpaPageLayout)source : this.createEntity(source);
    }

    private JpaPageLayout createEntity(PageLayout source) {
        JpaPageLayout converted = null;
        if (source != null) {
            TypedQuery query = this.manager.createNamedQuery("PageLayout.getByLayoutCode", JpaPageLayout.class);
            query.setParameter("code", (Object)source.getCode());
            converted = (JpaPageLayout)JpaUtil.getSingleResult(query.getResultList());
            if (converted == null) {
                converted = new JpaPageLayout();
            }
            this.updateProperties(source, converted);
        }
        return converted;
    }

    private void updateProperties(PageLayout source, JpaPageLayout converted) {
        converted.setCode(source.getCode());
        converted.setNumberOfRegions(source.getNumberOfRegions());
        converted.setRenderSequence(source.getRenderSequence());
        converted.setUserSelectable(source.isUserSelectable());
    }
}

