/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.rave.model.ModelConverter;
import org.apache.rave.model.PageUser;
import org.apache.rave.portal.model.JpaPageUser;
import org.springframework.stereotype.Component;

@Component
public class JpaPageUserConverter
implements ModelConverter<PageUser, JpaPageUser> {
    @PersistenceContext
    private EntityManager manager;

    public Class<PageUser> getSourceType() {
        return PageUser.class;
    }

    public JpaPageUser convert(PageUser source) {
        return source instanceof JpaPageUser ? (JpaPageUser)source : this.createEntity(source);
    }

    private JpaPageUser createEntity(PageUser source) {
        JpaPageUser converted = null;
        if (source != null) {
            JpaPageUser jpaPageUser = converted = source.getId() == null ? new JpaPageUser() : (JpaPageUser)this.manager.find(JpaPageUser.class, (Object)Long.parseLong(source.getId()));
            if (converted == null) {
                converted = new JpaPageUser();
            }
            this.updateProperties(source, converted);
        }
        return converted;
    }

    private void updateProperties(PageUser source, JpaPageUser converted) {
        converted.setEntityId(source.getId() == null ? null : Long.valueOf(Long.parseLong(source.getId())));
        converted.setPage(source.getPage());
        converted.setPageStatus(source.getPageStatus());
        converted.setRenderSequence(source.getRenderSequence());
        converted.setUserId(source.getUserId());
        converted.setEditor(source.isEditor());
    }
}

