/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.rave.model.ModelConverter;
import org.apache.rave.model.PortalPreference;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaPortalPreference;
import org.springframework.stereotype.Component;

@Component
public class JpaPortalPreferenceConverter
implements ModelConverter<PortalPreference, JpaPortalPreference> {
    @PersistenceContext
    private EntityManager manager;

    public Class<PortalPreference> getSourceType() {
        return PortalPreference.class;
    }

    public JpaPortalPreference convert(PortalPreference source) {
        return source instanceof JpaPortalPreference ? (JpaPortalPreference)source : this.createEntity(source);
    }

    private JpaPortalPreference createEntity(PortalPreference source) {
        JpaPortalPreference converted = null;
        if (source != null) {
            TypedQuery query = this.manager.createNamedQuery("PortalPreference.getByKey", JpaPortalPreference.class);
            query.setParameter("key", (Object)source.getKey());
            converted = (JpaPortalPreference)JpaUtil.getSingleResult(query.getResultList());
            if (converted == null) {
                converted = new JpaPortalPreference();
            }
            this.updateProperties(source, converted);
        }
        return converted;
    }

    private void updateProperties(PortalPreference source, JpaPortalPreference converted) {
        converted.setKey(source.getKey());
        converted.setValues(source.getValues());
    }
}

