/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.rave.model.ModelConverter;
import org.apache.rave.model.Tag;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaTag;
import org.springframework.stereotype.Component;

@Component
public class JpaTagConverter
implements ModelConverter<Tag, JpaTag> {
    @PersistenceContext
    private EntityManager manager;

    public Class<Tag> getSourceType() {
        return Tag.class;
    }

    public JpaTag convert(Tag source) {
        return source instanceof JpaTag ? (JpaTag)source : this.createEntity(source);
    }

    private JpaTag createEntity(Tag source) {
        TypedQuery query = this.manager.createNamedQuery("findByKeyword", JpaTag.class);
        query.setParameter("keyword", (Object)source.getKeyword());
        JpaTag convertedTag = (JpaTag)JpaUtil.getSingleResult(query.getResultList());
        if (convertedTag == null) {
            convertedTag = new JpaTag();
        }
        this.updateProperties(source, convertedTag);
        return convertedTag;
    }

    private void updateProperties(Tag source, JpaTag jpaTag) {
        jpaTag.setKeyword(source.getKeyword());
    }
}

