/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.rave.model.ModelConverter;
import org.apache.rave.model.Widget;
import org.apache.rave.portal.model.JpaWidget;
import org.springframework.stereotype.Component;

@Component
public class JpaWidgetConverter
implements ModelConverter<Widget, JpaWidget> {
    @PersistenceContext
    private EntityManager manager;

    public JpaWidget convert(Widget source) {
        return source instanceof JpaWidget ? (JpaWidget)source : this.createEntity(source);
    }

    public Class<Widget> getSourceType() {
        return Widget.class;
    }

    private JpaWidget createEntity(Widget source) {
        JpaWidget converted = null;
        if (source != null) {
            converted = new JpaWidget();
            this.updateProperties(source, converted);
        }
        return converted;
    }

    private void updateProperties(Widget source, JpaWidget converted) {
        converted.setEntityId(source.getId() == null ? null : Long.valueOf(Long.parseLong(source.getId())));
        converted.setUrl(source.getUrl());
        converted.setType(source.getType());
        converted.setTitle(source.getTitle());
        converted.setTitleUrl(source.getTitleUrl());
        converted.setUrl(source.getUrl());
        converted.setThumbnailUrl(source.getThumbnailUrl());
        converted.setScreenshotUrl(source.getScreenshotUrl());
        converted.setAuthor(source.getAuthor());
        converted.setAuthorEmail(source.getAuthorEmail());
        converted.setDescription(source.getDescription());
        converted.setWidgetStatus(source.getWidgetStatus());
        converted.setComments(source.getComments());
        converted.setOwnerId(source.getOwnerId());
        converted.setDisableRendering(source.isDisableRendering());
        converted.setRatings(source.getRatings());
        converted.setTags(source.getTags());
        converted.setCategories(source.getCategories());
        converted.setFeatured(source.isFeatured());
        converted.setProperties(source.getProperties());
    }
}

