/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.rave.model.WidgetTag;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaWidgetTag;
import org.springframework.stereotype.Component;

@Component
public class JpaWidgetTagConverter {
    @PersistenceContext
    private EntityManager manager;

    public Class<WidgetTag> getSourceType() {
        return WidgetTag.class;
    }

    public JpaWidgetTag convert(WidgetTag source, String widgetId) {
        return source instanceof JpaWidgetTag ? (JpaWidgetTag)source : this.createEntity(source, widgetId);
    }

    private JpaWidgetTag createEntity(WidgetTag source, String widgetId) {
        Long widgetEntityId = Long.parseLong(widgetId);
        TypedQuery query = this.manager.createNamedQuery("findByWidgetIDAndTagID", JpaWidgetTag.class);
        query.setParameter("widgetId", (Object)widgetEntityId);
        query.setParameter("tagId", (Object)Long.parseLong(source.getTagId()));
        JpaWidgetTag convertedWidgetTag = (JpaWidgetTag)JpaUtil.getSingleResult(query.getResultList());
        if (convertedWidgetTag == null) {
            convertedWidgetTag = new JpaWidgetTag();
        }
        this.updateProperties(source, convertedWidgetTag, widgetEntityId);
        return convertedWidgetTag;
    }

    private void updateProperties(WidgetTag source, JpaWidgetTag convertedWidgetTag, Long widgetId) {
        convertedWidgetTag.setCreatedDate(source.getCreatedDate());
        convertedWidgetTag.setTagEntityId(Long.parseLong(source.getTagId()));
        convertedWidgetTag.setUserEntityId(Long.parseLong(source.getUserId()));
        convertedWidgetTag.setWidgetEntityId(widgetId);
    }
}

