/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.repository.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.rave.exception.NotSupportedException;
import org.apache.rave.model.ActivityStreamsEntry;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaActivityStreamsEntry;
import org.apache.rave.portal.model.conversion.JpaActivityStreamsEntryConverter;
import org.apache.rave.portal.repository.ActivityStreamsRepository;
import org.apache.rave.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JpaActivityStreamsRepository
implements ActivityStreamsRepository {
    @PersistenceContext
    private EntityManager manager;
    @Autowired
    private JpaActivityStreamsEntryConverter converter;

    public Class<? extends ActivityStreamsEntry> getType() {
        return JpaActivityStreamsEntry.class;
    }

    @Transactional
    public ActivityStreamsEntry save(ActivityStreamsEntry e) {
        JpaActivityStreamsEntry entry = this.converter.convert(e);
        if (entry.getUserId() == null && entry.getActor() != null) {
            entry.setUserId(entry.getActor().getId());
        }
        return JpaUtil.saveOrUpdate(entry.getId(), this.manager, entry);
    }

    public List<ActivityStreamsEntry> getAll() {
        TypedQuery query = this.manager.createNamedQuery("JpaActivityStreamsEntry.findAll", JpaActivityStreamsEntry.class);
        return CollectionUtils.toBaseTypedList((List)query.getResultList());
    }

    public List<ActivityStreamsEntry> getLimitedList(int offset, int limit) {
        throw new NotSupportedException("This function is not yet implemented for this class.");
    }

    public int getCountAll() {
        throw new NotSupportedException("This function is not yet implemented for this class.");
    }

    public ActivityStreamsEntry get(String id) {
        TypedQuery query = this.manager.createNamedQuery("JpaActivityStreamsEntry.findById", JpaActivityStreamsEntry.class);
        query.setParameter("id", (Object)id);
        return (ActivityStreamsEntry)CollectionUtils.getSingleValue((List)query.getResultList());
    }

    public List<ActivityStreamsEntry> getByUserId(String id) {
        TypedQuery query = this.manager.createNamedQuery("JpaActivityStreamsEntry.findByUserId", JpaActivityStreamsEntry.class);
        query.setParameter("userId", (Object)id);
        return CollectionUtils.toBaseTypedList((List)query.getResultList());
    }

    @Transactional
    public void delete(ActivityStreamsEntry e) {
        this.deleteById(e.getId());
    }

    @Transactional
    public void deleteById(String id) {
        ActivityStreamsEntry e = this.get(id);
        this.manager.remove((Object)e);
    }
}

