/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.repository.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Lob;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.rave.exception.NotSupportedException;
import org.apache.rave.model.ApplicationData;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaApplicationData;
import org.apache.rave.portal.model.conversion.JpaApplicationDataConverter;
import org.apache.rave.portal.repository.ApplicationDataRepository;
import org.apache.rave.util.CollectionUtils;
import org.apache.rave.util.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JpaApplicationDataRepository
implements ApplicationDataRepository {
    @PersistenceContext
    private EntityManager manager;
    @Autowired
    private JpaApplicationDataConverter converter;

    public Class<? extends ApplicationData> getType() {
        return JpaApplicationData.class;
    }

    public ApplicationData get(String id) {
        JpaSerializableApplicationData applicationData = (JpaSerializableApplicationData)this.manager.find(JpaApplicationData.class, (Object)Long.parseLong(id));
        if (applicationData != null) {
            applicationData.deserializeData();
        }
        return applicationData;
    }

    @Transactional
    public JpaApplicationData save(ApplicationData item) {
        JpaApplicationData jpaAppData = this.converter.convert(item);
        JpaSerializableApplicationData jpaSerializableApplicationData = this.getJpaSerializableApplicationData(jpaAppData);
        jpaSerializableApplicationData.serializeData();
        return JpaUtil.saveOrUpdate(jpaSerializableApplicationData.getEntityId(), this.manager, jpaSerializableApplicationData);
    }

    public void delete(ApplicationData item) {
        this.manager.remove((Object)(item instanceof JpaApplicationData ? item : this.get(item.getId())));
    }

    public List<ApplicationData> getAll() {
        throw new NotSupportedException("This function is not yet implemented for this class.");
    }

    public List<ApplicationData> getLimitedList(int offset, int limit) {
        throw new NotSupportedException("This function is not yet implemented for this class.");
    }

    public int getCountAll() {
        throw new NotSupportedException("This function is not yet implemented for this class.");
    }

    public List<ApplicationData> getApplicationData(List<String> userIds, String appId) {
        if (userIds.size() == 1) {
            ArrayList<ApplicationData> data = new ArrayList<ApplicationData>();
            JpaApplicationData applicationData = this.getApplicationData(userIds.get(0), appId);
            if (applicationData != null) {
                data.add(applicationData);
            }
            return data;
        }
        TypedQuery query = this.manager.createNamedQuery("ApplicationData.findByUserIdsAndAppId", JpaSerializableApplicationData.class);
        query.setParameter("userIds", userIds);
        query.setParameter("appUrl", (Object)appId);
        List results = query.getResultList();
        for (JpaSerializableApplicationData applicationData : results) {
            applicationData.deserializeData();
        }
        return CollectionUtils.toBaseTypedList((List)results);
    }

    public JpaApplicationData getApplicationData(String personId, String appId) {
        TypedQuery query = this.manager.createNamedQuery("ApplicationData.findByUserIdAndAppId", JpaSerializableApplicationData.class);
        query.setParameter("userId", (Object)personId);
        query.setParameter("appUrl", (Object)appId);
        JpaSerializableApplicationData applicationData = (JpaSerializableApplicationData)JpaUtil.getSingleResult(query.getResultList());
        if (applicationData != null) {
            applicationData.deserializeData();
        }
        return applicationData;
    }

    private JpaSerializableApplicationData getJpaSerializableApplicationData(JpaApplicationData applicationData) {
        if (applicationData instanceof JpaSerializableApplicationData) {
            return (JpaSerializableApplicationData)applicationData;
        }
        return new JpaSerializableApplicationData(applicationData.getEntityId(), applicationData.getUserId(), applicationData.getAppUrl(), applicationData.getData());
    }

    @Entity
    public static class JpaSerializableApplicationData
    extends JpaApplicationData
    implements PersistenceCapable {
        @Lob
        @Column(name="serialized_data")
        private String serializedData;
        private static int pcInheritedFieldCount = JpaApplicationData.pcGetManagedFieldCount();
        private static String[] pcFieldNames;
        private static Class[] pcFieldTypes;
        private static byte[] pcFieldFlags;
        private static Class pcPCSuperclass;
        static /* synthetic */ Class class$Lorg$apache$rave$portal$model$JpaApplicationData;
        static /* synthetic */ Class class$Ljava$lang$String;
        static /* synthetic */ Class class$Lorg$apache$rave$portal$repository$impl$JpaApplicationDataRepository$JpaSerializableApplicationData;

        public JpaSerializableApplicationData() {
        }

        public JpaSerializableApplicationData(Long entityId, String userId, String appUrl, Map<String, Object> data) {
            super(entityId, userId, appUrl, data);
        }

        public void serializeData() {
            Map<String, Object> data = this.getData();
            if (data != null) {
                JpaSerializableApplicationData.pcSetserializedData(this, JsonUtils.stringify(data));
            }
        }

        public void deserializeData() {
            if (JpaSerializableApplicationData.pcGetserializedData(this) != null && StringUtils.isNotBlank((CharSequence)JpaSerializableApplicationData.pcGetserializedData(this))) {
                this.setData((Map)JsonUtils.parse((String)JpaSerializableApplicationData.pcGetserializedData(this), Map.class));
            }
        }

        @Override
        public int pcGetEnhancementContractVersion() {
            return 1468245;
        }

        static {
            Class clazz = class$Lorg$apache$rave$portal$model$JpaApplicationData != null ? class$Lorg$apache$rave$portal$model$JpaApplicationData : (class$Lorg$apache$rave$portal$model$JpaApplicationData = JpaSerializableApplicationData.class$("org.apache.rave.portal.model.JpaApplicationData"));
            pcPCSuperclass = clazz;
            pcFieldNames = new String[]{"serializedData"};
            Class[] classArray = new Class[1];
            Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaSerializableApplicationData.class$("java.lang.String"));
            classArray[0] = clazz2;
            pcFieldTypes = classArray;
            pcFieldFlags = new byte[]{26};
            Class clazz3 = class$Lorg$apache$rave$portal$repository$impl$JpaApplicationDataRepository$JpaSerializableApplicationData != null ? class$Lorg$apache$rave$portal$repository$impl$JpaApplicationDataRepository$JpaSerializableApplicationData : (class$Lorg$apache$rave$portal$repository$impl$JpaApplicationDataRepository$JpaSerializableApplicationData = JpaSerializableApplicationData.class$("org.apache.rave.portal.repository.impl.JpaApplicationDataRepository$JpaSerializableApplicationData"));
            PCRegistry.register((Class)clazz3, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JpaApplicationDataRepository$JpaSerializableApplicationData", (PersistenceCapable)new JpaSerializableApplicationData());
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        @Override
        protected void pcClearFields() {
            super.pcClearFields();
            this.serializedData = null;
        }

        @Override
        public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
            JpaSerializableApplicationData jpaSerializableApplicationData = new JpaSerializableApplicationData();
            if (bl) {
                jpaSerializableApplicationData.pcClearFields();
            }
            jpaSerializableApplicationData.pcStateManager = stateManager;
            jpaSerializableApplicationData.pcCopyKeyFieldsFromObjectId(object);
            return jpaSerializableApplicationData;
        }

        @Override
        public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
            JpaSerializableApplicationData jpaSerializableApplicationData = new JpaSerializableApplicationData();
            if (bl) {
                jpaSerializableApplicationData.pcClearFields();
            }
            jpaSerializableApplicationData.pcStateManager = stateManager;
            return jpaSerializableApplicationData;
        }

        protected static int pcGetManagedFieldCount() {
            return 1 + JpaApplicationData.pcGetManagedFieldCount();
        }

        @Override
        public void pcReplaceField(int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                super.pcReplaceField(n);
                return;
            }
            switch (n2) {
                case 0: {
                    this.serializedData = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void pcReplaceFields(int[] nArray) {
            int n = 0;
            while (n < nArray.length) {
                this.pcReplaceField(nArray[n]);
                ++n;
            }
        }

        @Override
        public void pcProvideField(int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                super.pcProvideField(n);
                return;
            }
            switch (n2) {
                case 0: {
                    this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.serializedData);
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void pcProvideFields(int[] nArray) {
            int n = 0;
            while (n < nArray.length) {
                this.pcProvideField(nArray[n]);
                ++n;
            }
        }

        protected void pcCopyField(JpaSerializableApplicationData jpaSerializableApplicationData, int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                super.pcCopyField(jpaSerializableApplicationData, n);
                return;
            }
            switch (n2) {
                case 0: {
                    this.serializedData = jpaSerializableApplicationData.serializedData;
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void pcCopyFields(Object object, int[] nArray) {
            JpaSerializableApplicationData jpaSerializableApplicationData = (JpaSerializableApplicationData)object;
            if (jpaSerializableApplicationData.pcStateManager != this.pcStateManager) {
                throw new IllegalArgumentException();
            }
            if (this.pcStateManager == null) {
                throw new IllegalStateException();
            }
            int n = 0;
            while (n < nArray.length) {
                this.pcCopyField(jpaSerializableApplicationData, nArray[n]);
                ++n;
            }
        }

        private static final String pcGetserializedData(JpaSerializableApplicationData jpaSerializableApplicationData) {
            if (jpaSerializableApplicationData.pcStateManager == null) {
                return jpaSerializableApplicationData.serializedData;
            }
            int n = pcInheritedFieldCount + 0;
            jpaSerializableApplicationData.pcStateManager.accessingField(n);
            return jpaSerializableApplicationData.serializedData;
        }

        private static final void pcSetserializedData(JpaSerializableApplicationData jpaSerializableApplicationData, String string) {
            if (jpaSerializableApplicationData.pcStateManager == null) {
                jpaSerializableApplicationData.serializedData = string;
                return;
            }
            jpaSerializableApplicationData.pcStateManager.settingStringField((PersistenceCapable)jpaSerializableApplicationData, pcInheritedFieldCount + 0, jpaSerializableApplicationData.serializedData, string, 0);
        }
    }
}

