/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.repository.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.rave.exception.NotSupportedException;
import org.apache.rave.model.Authority;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaAuthority;
import org.apache.rave.portal.model.conversion.JpaAuthorityConverter;
import org.apache.rave.portal.repository.AuthorityRepository;
import org.apache.rave.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JpaAuthorityRepository
implements AuthorityRepository {
    @PersistenceContext
    private EntityManager manager;
    @Autowired
    private JpaAuthorityConverter converter;

    public Authority getByAuthority(String authorityName) {
        TypedQuery query = this.manager.createNamedQuery("Authority.GetByAuthorityName", JpaAuthority.class);
        query.setParameter("authority", (Object)authorityName);
        return (Authority)JpaUtil.getSingleResult(query.getResultList());
    }

    public List<Authority> getAll() {
        TypedQuery query = this.manager.createNamedQuery("Authority.GetAll", JpaAuthority.class);
        return CollectionUtils.toBaseTypedList((List)query.getResultList());
    }

    public List<Authority> getLimitedList(int offset, int limit) {
        throw new NotSupportedException("This function is not yet implemented for this class.");
    }

    public List<Authority> getAllDefault() {
        TypedQuery query = this.manager.createNamedQuery("Authority.GetAllDefault", JpaAuthority.class);
        return CollectionUtils.toBaseTypedList((List)query.getResultList());
    }

    public int getCountAll() {
        Query query = this.manager.createNamedQuery("Authority.CountAll");
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    public Class<? extends Authority> getType() {
        return JpaAuthority.class;
    }

    public Authority get(String id) {
        return (Authority)this.manager.find(JpaAuthority.class, (Object)Long.parseLong(id));
    }

    public Authority save(Authority item) {
        JpaAuthority authority = this.converter.convert(item);
        return JpaUtil.saveOrUpdate(authority.getEntityId(), this.manager, authority);
    }

    public void delete(Authority item) {
        this.manager.remove((Object)this.converter.convert(item));
    }
}

