/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.repository.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.rave.model.Category;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaCategory;
import org.apache.rave.portal.model.conversion.JpaCategoryConverter;
import org.apache.rave.portal.repository.CategoryRepository;
import org.apache.rave.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JpaCategoryRepository
implements CategoryRepository {
    @PersistenceContext
    private EntityManager manager;
    @Autowired
    private JpaCategoryConverter categoryConverter;

    public Class<? extends Category> getType() {
        return JpaCategory.class;
    }

    public Category get(String id) {
        return (Category)this.manager.find(JpaCategory.class, (Object)Long.parseLong(id));
    }

    public Category save(Category item) {
        JpaCategory category = this.categoryConverter.convert(item);
        return JpaUtil.saveOrUpdate(category.getEntityId(), this.manager, category);
    }

    public void delete(Category item) {
        this.manager.remove((Object)(item instanceof JpaCategory ? item : this.get(item.getId())));
    }

    public List<Category> getAll() {
        List resultList = this.manager.createNamedQuery("Category.getAll", JpaCategory.class).getResultList();
        return CollectionUtils.toBaseTypedList((List)resultList);
    }

    public List<Category> getLimitedList(int offset, int limit) {
        TypedQuery query = this.manager.createNamedQuery("Category.getAll", JpaCategory.class);
        return CollectionUtils.toBaseTypedList(JpaUtil.getPagedResultList(query, offset, limit));
    }

    public int getCountAll() {
        Query query = this.manager.createNamedQuery("Category.getCountAll");
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    public int removeFromCreatedOrModifiedFields(String userId) {
        List<Category> categories = this.getAll();
        int numRecordsChanged = 0;
        for (Category category : categories) {
            boolean changed = false;
            String createdUser = category.getCreatedUserId();
            String lastModifiedUser = category.getLastModifiedUserId();
            if (createdUser != null && userId.equals(createdUser)) {
                category.setCreatedUserId(null);
                changed = true;
            }
            if (lastModifiedUser != null && userId.equals(lastModifiedUser)) {
                category.setLastModifiedUserId(null);
                changed = true;
            }
            if (!changed) continue;
            ++numRecordsChanged;
            this.save(category);
        }
        return numRecordsChanged;
    }
}

