/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.repository.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.rave.exception.NotSupportedException;
import org.apache.rave.model.Group;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaGroup;
import org.apache.rave.portal.model.conversion.JpaGroupConverter;
import org.apache.rave.repository.GroupRepository;
import org.apache.rave.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JpaGroupRepository
implements GroupRepository {
    @Autowired
    private JpaGroupConverter converter;
    @PersistenceContext
    private EntityManager manager;

    public Class<? extends Group> getType() {
        return JpaGroup.class;
    }

    public Group get(String id) {
        long primaryKey = Long.parseLong(id);
        return (Group)this.manager.find(JpaGroup.class, (Object)primaryKey);
    }

    public List<Group> getAll() {
        TypedQuery query = this.manager.createNamedQuery("Group.getAll", JpaGroup.class);
        return CollectionUtils.toBaseTypedList((List)query.getResultList());
    }

    public List<Group> getLimitedList(int offset, int limit) {
        throw new NotSupportedException("This function is not yet implemented for this class.");
    }

    public int getCountAll() {
        throw new NotSupportedException("This function is not yet implemented for this class.");
    }

    public Group save(Group item) {
        JpaGroup converted = this.converter.convert(item);
        return JpaUtil.saveOrUpdate(converted.getEntityId(), this.manager, converted);
    }

    public void delete(Group item) {
        this.manager.remove((Object)this.converter.convert(item));
    }

    public Group findByTitle(String title) {
        TypedQuery query = this.manager.createNamedQuery("Group.findByTitle", JpaGroup.class);
        query.setParameter("title", (Object)title);
        return (Group)JpaUtil.getSingleResult(query.getResultList());
    }
}

