/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.repository.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.rave.exception.NotSupportedException;
import org.apache.rave.model.FriendRequestStatus;
import org.apache.rave.model.Person;
import org.apache.rave.model.User;
import org.apache.rave.model.Widget;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaGroup;
import org.apache.rave.portal.model.JpaPerson;
import org.apache.rave.portal.model.JpaPersonAssociation;
import org.apache.rave.portal.model.JpaUser;
import org.apache.rave.portal.model.JpaWidget;
import org.apache.rave.portal.model.conversion.JpaPersonConverter;
import org.apache.rave.portal.repository.PersonRepository;
import org.apache.rave.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JpaPersonRepository
implements PersonRepository {
    @PersistenceContext
    private EntityManager manager;
    @Autowired
    private JpaPersonConverter personConverter;

    public Person findByUsername(String username) {
        TypedQuery query = this.manager.createNamedQuery("Person.findByUsername", JpaPerson.class);
        query.setParameter("username", (Object)username);
        return (Person)JpaUtil.getSingleResult(query.getResultList());
    }

    public List<Person> findAllConnectedPeople(String username) {
        Person person = this.findByUsername(username);
        LinkedList connections = Lists.newLinkedList();
        if (person != null) {
            String personId = person.getId();
            connections.addAll(this.findFriends(username));
            TypedQuery members = this.manager.createQuery("SELECT g from JpaGroup g where :userId member of g.members", JpaGroup.class);
            members.setParameter("userId", (Object)personId);
            for (JpaGroup groups : members.getResultList()) {
                this.addPeopleByIds(groups, connections);
            }
        }
        connections.remove(person);
        return connections;
    }

    public List<Person> findAllConnectedPeople(String username, String appId) {
        throw new NotSupportedException();
    }

    public List<Person> findAllConnectedPeopleWithFriend(String username, String friendUsername) {
        throw new NotSupportedException();
    }

    public List<Person> findFriends(String username) {
        TypedQuery friends = this.manager.createNamedQuery("Person.findFriendsByUsername", JpaPerson.class);
        friends.setParameter("username", (Object)username);
        friends.setParameter("status", (Object)FriendRequestStatus.ACCEPTED);
        return CollectionUtils.toBaseTypedList((List)friends.getResultList());
    }

    public List<Person> findFriends(String username, String appId) {
        ArrayList<Person> friendsUsingWidget = new ArrayList<Person>();
        TypedQuery widgetQuery = this.manager.createNamedQuery("Widget.getByUrl", JpaWidget.class);
        widgetQuery.setParameter("url", (Object)appId);
        List resultList = widgetQuery.getResultList();
        Widget widget = (Widget)JpaUtil.getSingleResult(resultList);
        TypedQuery usersQuery = this.manager.createNamedQuery("User.getAllForAddedWidget", JpaUser.class);
        usersQuery.setParameter("widgetId", (Object)Long.parseLong(widget.getId()));
        List widgetUsers = CollectionUtils.toBaseTypedList((List)usersQuery.getResultList());
        List<Person> userFriends = this.findFriends(username);
        for (Person userFriend : userFriends) {
            for (User widgetUser : widgetUsers) {
                if (!userFriend.getUsername().equals(widgetUser.getUsername())) continue;
                friendsUsingWidget.add(userFriend);
            }
        }
        return friendsUsingWidget;
    }

    public List<Person> findFriendsWithFriend(String username, String friendUsername) {
        ArrayList<Person> friendsWithFriend = new ArrayList<Person>();
        List<Person> userFriends = this.findFriends(username);
        List<Person> friendFriends = this.findFriends(friendUsername);
        for (Person userFriend : userFriends) {
            for (Person friendFriend : friendFriends) {
                if (!userFriend.getUsername().equals(friendFriend.getUsername())) continue;
                friendsWithFriend.add(userFriend);
            }
        }
        return friendsWithFriend;
    }

    public List<Person> findByGroup(String groupId) {
        TypedQuery query = this.manager.createNamedQuery("Group.findByTitle", JpaGroup.class);
        query.setParameter("title", (Object)groupId);
        return this.getPeopleByIds((JpaGroup)JpaUtil.getSingleResult(query.getResultList()));
    }

    public List<Person> findByGroup(String groupId, String appId) {
        throw new NotSupportedException();
    }

    public List<Person> findByGroupWithFriend(String groupId, String friendUsername) {
        throw new NotSupportedException();
    }

    public Class<? extends Person> getType() {
        return JpaPerson.class;
    }

    public Person get(String id) {
        return (Person)this.manager.find(JpaPerson.class, (Object)Long.parseLong(id));
    }

    public Person save(Person item) {
        JpaPerson person = this.personConverter.convert(item);
        return JpaUtil.saveOrUpdate(person.getEntityId(), this.manager, person);
    }

    public void delete(Person item) {
        this.manager.remove((Object)(item instanceof JpaPerson ? item : this.findByUsername(item.getUsername())));
    }

    public boolean addFriend(String friendUsername, String username) {
        JpaPersonAssociation senderItem = new JpaPersonAssociation();
        senderItem.setFollower(this.personConverter.convert(this.findByUsername(username)));
        senderItem.setFollowedby(this.personConverter.convert(this.findByUsername(friendUsername)));
        senderItem.setStatus(FriendRequestStatus.SENT);
        senderItem = JpaUtil.saveOrUpdate(senderItem.getEntityId(), this.manager, senderItem);
        JpaPersonAssociation receiverItem = new JpaPersonAssociation();
        receiverItem.setFollower(this.personConverter.convert(this.findByUsername(friendUsername)));
        receiverItem.setFollowedby(this.personConverter.convert(this.findByUsername(username)));
        receiverItem.setStatus(FriendRequestStatus.RECEIVED);
        receiverItem = JpaUtil.saveOrUpdate(receiverItem.getEntityId(), this.manager, receiverItem);
        return senderItem.getEntityId() != null && receiverItem.getEntityId() != null;
    }

    public void removeFriend(String friendUsername, String username) {
        TypedQuery query = this.manager.createNamedQuery("PersonAssociation.findAssociationItemByUsernames", JpaPersonAssociation.class);
        query.setParameter("follower_username", (Object)username);
        query.setParameter("followedby_username", (Object)friendUsername);
        JpaPersonAssociation item = (JpaPersonAssociation)JpaUtil.getSingleResult(query.getResultList());
        this.manager.remove((Object)item);
        query = this.manager.createNamedQuery("PersonAssociation.findAssociationItemByUsernames", JpaPersonAssociation.class);
        query.setParameter("follower_username", (Object)friendUsername);
        query.setParameter("followedby_username", (Object)username);
        JpaPersonAssociation inverseItem = (JpaPersonAssociation)JpaUtil.getSingleResult(query.getResultList());
        this.manager.remove((Object)inverseItem);
    }

    public HashMap<String, List<Person>> findFriendsAndRequests(String username) {
        HashMap<String, List<Person>> friendsAndRequests = new HashMap<String, List<Person>>();
        friendsAndRequests.put(FriendRequestStatus.ACCEPTED.toString(), this.findFriends(username));
        friendsAndRequests.put(FriendRequestStatus.SENT.toString(), this.findFriendRequestsSent(username));
        friendsAndRequests.put(FriendRequestStatus.RECEIVED.toString(), this.findFriendRequestsReceived(username));
        return friendsAndRequests;
    }

    public List<Person> findFriendRequestsSent(String username) {
        TypedQuery friends = this.manager.createNamedQuery("Person.findFriendsByUsername", JpaPerson.class);
        friends.setParameter("username", (Object)username);
        friends.setParameter("status", (Object)FriendRequestStatus.SENT);
        return CollectionUtils.toBaseTypedList((List)friends.getResultList());
    }

    public List<Person> findFriendRequestsReceived(String username) {
        TypedQuery friends = this.manager.createNamedQuery("Person.findFriendsByUsername", JpaPerson.class);
        friends.setParameter("username", (Object)username);
        friends.setParameter("status", (Object)FriendRequestStatus.RECEIVED);
        return CollectionUtils.toBaseTypedList((List)friends.getResultList());
    }

    public boolean acceptFriendRequest(String friendUsername, String username) {
        TypedQuery query = this.manager.createNamedQuery("PersonAssociation.findAssociationItemByUsernames", JpaPersonAssociation.class);
        query.setParameter("follower_username", (Object)username);
        query.setParameter("followedby_username", (Object)friendUsername);
        JpaPersonAssociation receiverItem = (JpaPersonAssociation)JpaUtil.getSingleResult(query.getResultList());
        receiverItem.setStatus(FriendRequestStatus.ACCEPTED);
        receiverItem = JpaUtil.saveOrUpdate(receiverItem.getEntityId(), this.manager, receiverItem);
        query = this.manager.createNamedQuery("PersonAssociation.findAssociationItemByUsernames", JpaPersonAssociation.class);
        query.setParameter("follower_username", (Object)friendUsername);
        query.setParameter("followedby_username", (Object)username);
        JpaPersonAssociation senderItem = (JpaPersonAssociation)JpaUtil.getSingleResult(query.getResultList());
        senderItem.setStatus(FriendRequestStatus.ACCEPTED);
        senderItem = JpaUtil.saveOrUpdate(senderItem.getEntityId(), this.manager, senderItem);
        return receiverItem.getEntityId() != null && senderItem.getEntityId() != null;
    }

    public int removeAllFriendsAndRequests(String userid) {
        TypedQuery query = this.manager.createNamedQuery("PersonAssociation.deleteAssociationItemsByUserid", JpaPersonAssociation.class);
        query.setParameter("userid", (Object)Long.parseLong(userid));
        return query.executeUpdate();
    }

    private List<Person> getPeopleByIds(JpaGroup result) {
        LinkedList members = Lists.newLinkedList();
        this.addPeopleByIds(result, members);
        return members;
    }

    private void addPeopleByIds(JpaGroup result, List<Person> members) {
        if (result != null) {
            for (String personId : result.getMemberIds()) {
                Person person = this.get(personId);
                if (members.contains(person)) continue;
                members.add(person);
            }
        }
    }

    public List<Person> getAll() {
        TypedQuery query = this.manager.createNamedQuery("Person.getAll", Person.class);
        return CollectionUtils.toBaseTypedList((List)query.getResultList());
    }

    public List<Person> getLimitedList(int offset, int limit) {
        TypedQuery query = this.manager.createNamedQuery("Person.getAll", Person.class);
        return CollectionUtils.toBaseTypedList(JpaUtil.getPagedResultList(query, offset, limit));
    }

    public int getCountAll() {
        Query query = this.manager.createNamedQuery("Person.getCount");
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }
}

