/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.repository.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.rave.model.PortalPreference;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaPortalPreference;
import org.apache.rave.portal.model.conversion.JpaPortalPreferenceConverter;
import org.apache.rave.portal.repository.PortalPreferenceRepository;
import org.apache.rave.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JpaPortalPreferenceRepository
implements PortalPreferenceRepository {
    @PersistenceContext
    private EntityManager manager;
    @Autowired
    private JpaPortalPreferenceConverter converter;

    public List<PortalPreference> getAll() {
        TypedQuery query = this.manager.createNamedQuery("PortalPreference.getAll", JpaPortalPreference.class);
        return CollectionUtils.toBaseTypedList((List)query.getResultList());
    }

    public List<PortalPreference> getLimitedList(int offset, int pageSize) {
        TypedQuery query = this.manager.createNamedQuery("PortalPreference.getAll", JpaPortalPreference.class);
        return CollectionUtils.toBaseTypedList(JpaUtil.getPagedResultList(query, offset, pageSize));
    }

    public int getCountAll() {
        Query query = this.manager.createNamedQuery("PortalPreference.countAll");
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    public PortalPreference getByKey(String key) {
        TypedQuery query = this.manager.createNamedQuery("PortalPreference.getByKey", JpaPortalPreference.class);
        query.setParameter("key", (Object)key);
        return (PortalPreference)JpaUtil.getSingleResult(query.getResultList());
    }

    public Class<? extends PortalPreference> getType() {
        return JpaPortalPreference.class;
    }

    public PortalPreference get(String id) {
        return (PortalPreference)this.manager.find(JpaPortalPreference.class, (Object)Long.parseLong(id));
    }

    public PortalPreference save(PortalPreference item) {
        JpaPortalPreference pref = this.converter.convert(item);
        return JpaUtil.saveOrUpdate(pref.getEntityId(), this.manager, pref);
    }

    public void delete(PortalPreference item) {
        this.manager.remove((Object)this.converter.convert(item));
    }
}

