/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.repository.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.rave.model.Region;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaRegion;
import org.apache.rave.portal.model.conversion.JpaRegionConverter;
import org.apache.rave.portal.repository.RegionRepository;
import org.apache.rave.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JpaRegionRepository
implements RegionRepository {
    private final Logger log = LoggerFactory.getLogger(JpaRegionRepository.class);
    @PersistenceContext
    private EntityManager manager;
    @Autowired
    private JpaRegionConverter regionConverter;

    public Class<? extends Region> getType() {
        return JpaRegion.class;
    }

    public Region get(String id) {
        return (Region)this.manager.find(JpaRegion.class, (Object)Long.parseLong(id));
    }

    public Region save(Region item) {
        JpaRegion region = this.regionConverter.convert(item);
        return JpaUtil.saveOrUpdate(region.getEntityId(), this.manager, region);
    }

    public void delete(Region item) {
        this.manager.remove((Object)(item instanceof JpaRegion ? item : this.get(item.getId())));
    }

    public List<Region> getAll() {
        this.log.warn("Requesting potentially large resultset of Region. No pagesize set.");
        TypedQuery query = this.manager.createNamedQuery("Region.getAll", JpaRegion.class);
        return CollectionUtils.toBaseTypedList((List)query.getResultList());
    }

    public List<Region> getLimitedList(int offset, int pageSize) {
        TypedQuery query = this.manager.createNamedQuery("Region.getAll", JpaRegion.class);
        return CollectionUtils.toBaseTypedList(JpaUtil.getPagedResultList(query, offset, pageSize));
    }

    public int getCountAll() {
        Query query = this.manager.createNamedQuery("Region.countAll");
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }
}

