/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.repository.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.rave.model.RegionWidget;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaRegionWidget;
import org.apache.rave.portal.model.conversion.JpaRegionWidgetConverter;
import org.apache.rave.portal.repository.RegionWidgetRepository;
import org.apache.rave.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JpaRegionWidgetRepository
implements RegionWidgetRepository {
    private final Logger log = LoggerFactory.getLogger(JpaRegionWidgetRepository.class);
    @PersistenceContext
    private EntityManager manager;
    @Autowired
    private JpaRegionWidgetConverter regionWidgetConverter;

    public Class<? extends RegionWidget> getType() {
        return JpaRegionWidget.class;
    }

    public RegionWidget get(String id) {
        return (RegionWidget)this.manager.find(JpaRegionWidget.class, (Object)Long.parseLong(id));
    }

    public RegionWidget save(RegionWidget item) {
        JpaRegionWidget region = this.regionWidgetConverter.convert(item);
        return JpaUtil.saveOrUpdate(region.getEntityId(), this.manager, region);
    }

    public void delete(RegionWidget item) {
        this.manager.remove((Object)(item instanceof JpaRegionWidget ? item : this.get(item.getId())));
    }

    public List<RegionWidget> getAll() {
        this.log.warn("Requesting potentially large resultset of RegionWidget. No pagesize set.");
        TypedQuery query = this.manager.createNamedQuery("JpaRegionWidget.getAll", JpaRegionWidget.class);
        return CollectionUtils.toBaseTypedList((List)query.getResultList());
    }

    public List<RegionWidget> getLimitedList(int offset, int pageSize) {
        TypedQuery query = this.manager.createNamedQuery("JpaRegionWidget.getAll", JpaRegionWidget.class);
        return CollectionUtils.toBaseTypedList(JpaUtil.getPagedResultList(query, offset, pageSize));
    }

    public int getCountAll() {
        Query query = this.manager.createNamedQuery("JpaRegionWidget.countAll");
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }
}

