/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.repository.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.rave.model.Tag;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaTag;
import org.apache.rave.portal.model.conversion.JpaTagConverter;
import org.apache.rave.portal.repository.TagRepository;
import org.apache.rave.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JpaTagRepository
implements TagRepository {
    @PersistenceContext
    private EntityManager manager;
    @Autowired
    private JpaTagConverter converter;

    public List<Tag> getAll() {
        TypedQuery query = this.manager.createNamedQuery("getAll", JpaTag.class);
        return CollectionUtils.toBaseTypedList((List)query.getResultList());
    }

    public List<Tag> getLimitedList(int offset, int limit) {
        TypedQuery query = this.manager.createNamedQuery("getAll", JpaTag.class);
        return CollectionUtils.toBaseTypedList(JpaUtil.getPagedResultList(query, offset, limit));
    }

    public Class<? extends Tag> getType() {
        return JpaTag.class;
    }

    public int getCountAll() {
        Query query = this.manager.createNamedQuery("countAll");
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    public JpaTag getByKeyword(String keyword) {
        if (keyword != null) {
            keyword = keyword.trim();
        }
        TypedQuery query = this.manager.createNamedQuery("findByKeyword", JpaTag.class);
        query.setParameter("keyword", (Object)keyword);
        return (JpaTag)JpaUtil.getSingleResult(query.getResultList());
    }

    public Tag get(String id) {
        return (Tag)this.manager.find(JpaTag.class, (Object)Long.parseLong(id));
    }

    public Tag save(Tag item) {
        JpaTag tag = this.converter.convert(item);
        return JpaUtil.saveOrUpdate(tag.getEntityId(), this.manager, tag);
    }

    public void delete(Tag item) {
        this.manager.remove(item instanceof JpaTag ? item : this.getByKeyword(item.getKeyword()));
    }
}

