/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.repository.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.rave.model.User;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaUser;
import org.apache.rave.portal.model.conversion.JpaUserConverter;
import org.apache.rave.portal.repository.UserRepository;
import org.apache.rave.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JpaUserRepository
implements UserRepository {
    private final Logger log = LoggerFactory.getLogger(JpaUserRepository.class);
    @Autowired
    private JpaUserConverter converter;
    @PersistenceContext
    private EntityManager manager;

    public User getByUsername(String username) {
        TypedQuery query = this.manager.createNamedQuery("User.getByUsername", JpaUser.class);
        query.setParameter("username", (Object)username);
        return (User)JpaUtil.getSingleResult(query.getResultList());
    }

    public User getByUserEmail(String userEmail) {
        TypedQuery query = this.manager.createNamedQuery("User.getByUserEmail", JpaUser.class);
        query.setParameter("email", (Object)userEmail);
        return (User)JpaUtil.getSingleResult(query.getResultList());
    }

    public User getByOpenId(String openId) {
        TypedQuery query = this.manager.createNamedQuery("User.getByOpenId", JpaUser.class);
        query.setParameter("openId", (Object)openId);
        return (User)JpaUtil.getSingleResult(query.getResultList());
    }

    public List<User> getAll() {
        this.log.warn("Requesting potentially large resultset of Users. No pagesize set.");
        TypedQuery query = this.manager.createNamedQuery("User.getAll", JpaUser.class);
        return CollectionUtils.toBaseTypedList((List)query.getResultList());
    }

    public List<User> getLimitedList(int offset, int pageSize) {
        TypedQuery query = this.manager.createNamedQuery("User.getAll", JpaUser.class);
        return CollectionUtils.toBaseTypedList(JpaUtil.getPagedResultList(query, offset, pageSize));
    }

    public int getCountAll() {
        Query query = this.manager.createNamedQuery("User.countAll");
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    public List<User> findByUsernameOrEmail(String searchTerm, int offset, int pageSize) {
        TypedQuery query = this.manager.createNamedQuery("User.findByUsernameOrEmail", JpaUser.class);
        query.setParameter("searchTerm", (Object)("%" + searchTerm.toLowerCase() + "%"));
        return CollectionUtils.toBaseTypedList(JpaUtil.getPagedResultList(query, offset, pageSize));
    }

    public int getCountByUsernameOrEmail(String searchTerm) {
        Query query = this.manager.createNamedQuery("User.countFindByUsernameOrEmail");
        query.setParameter("searchTerm", (Object)("%" + searchTerm.toLowerCase() + "%"));
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    public List<User> getAllByAddedWidget(String widgetId) {
        TypedQuery query = this.manager.createNamedQuery("User.getAllForAddedWidget", JpaUser.class);
        query.setParameter("widgetId", (Object)Long.parseLong(widgetId));
        return CollectionUtils.toBaseTypedList((List)query.getResultList());
    }

    public User getByForgotPasswordHash(String hash) {
        TypedQuery query = this.manager.createNamedQuery("User.getByForgotPasswordHash", JpaUser.class);
        query.setParameter("forgotPasswordHash", (Object)hash);
        return (User)JpaUtil.getSingleResult(query.getResultList());
    }

    public Class<? extends User> getType() {
        return JpaUser.class;
    }

    public User get(String id) {
        long primaryKey = Long.parseLong(id);
        return (User)this.manager.find(JpaUser.class, (Object)primaryKey);
    }

    public User save(User item) {
        JpaUser converted = this.converter.convert(item);
        return JpaUtil.saveOrUpdate(converted.getEntityId(), this.manager, converted);
    }

    public void delete(User item) {
        this.manager.remove((Object)this.converter.convert(item));
    }
}

