/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.provider.opensocial.config;

import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rave.portal.events.PortalPreferenceJavascriptDebugModeEventListener;
import org.apache.rave.portal.events.PortalPreferenceJavascriptDebugModeSaveEvent;
import org.apache.rave.portal.events.RaveEvent;
import org.apache.rave.portal.events.RaveEventListener;
import org.apache.rave.portal.events.RaveEventManager;
import org.apache.rave.portal.service.PortalPreferenceService;
import org.apache.rave.portal.web.renderer.ScriptLocation;
import org.apache.rave.portal.web.renderer.ScriptManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OpenSocialEnvironment
implements PortalPreferenceJavascriptDebugModeEventListener {
    private static final Log log = LogFactory.getLog(OpenSocialEnvironment.class);
    private static final String CONTAINER_JS_KEY = "containerJs";
    private static final String SCRIPT_RENDER_DEBUG_ON = "1";
    private static final String SCRIPT_TEMPLATE = "<script>requirejs.config({paths: {\"osapi\":\"%1$s://%2$s%3$s/js/%4$s.js?c=1&container=default&debug=%5$s\"}});</script>";
    private String currentDebugMode;
    private ScriptManager scriptManager;
    private String engineProtocol;
    private String engineRoot;
    private String engineGadgetPath;
    private String containerFeatures;
    @Autowired
    RaveEventManager eventManager;
    @Autowired
    PortalPreferenceService portalPreferenceService;

    @PostConstruct
    public void init() {
        this.eventManager.addListener(PortalPreferenceJavascriptDebugModeSaveEvent.class, (RaveEventListener)this);
        try {
            this.setCurrentDebugMode(this.portalPreferenceService.getPreference("javaScriptDebugMode").getValue());
        }
        catch (Exception e) {
            log.warn((Object)"Caught exception getting preference for JS debug mode. Setting JS to debug mode to 'debug on'.");
            this.setCurrentDebugMode(SCRIPT_RENDER_DEBUG_ON);
        }
        this.registerScriptBlock();
    }

    public ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    @Autowired
    public void setScriptManager(ScriptManager scriptManager) {
        this.scriptManager = scriptManager;
    }

    @Value(value="${portal.opensocial_engine.protocol}")
    public void setEngineProtocol(String engineProtocol) {
        this.engineProtocol = engineProtocol;
    }

    public String getEngineProtocol() {
        return this.engineProtocol;
    }

    @Value(value="${portal.opensocial_engine.root}")
    public void setEngineRoot(String engineRoot) {
        this.engineRoot = engineRoot;
    }

    public String getEngineRoot() {
        return this.engineRoot;
    }

    @Value(value="${portal.opensocial_engine.gadget_path}")
    public void setEngineGadgetPath(String engineGadgetPath) {
        this.engineGadgetPath = engineGadgetPath;
    }

    public String getEngineGadgetPath() {
        return this.engineGadgetPath;
    }

    @Value(value="${portal.opensocial_engine.container_features}")
    public void setContainerFeatures(String containerFeatures) {
        this.containerFeatures = containerFeatures;
    }

    public String getContainerFeatures() {
        return this.containerFeatures;
    }

    public String getCurrentDebugMode() {
        return this.currentDebugMode;
    }

    public void setCurrentDebugMode(String currentDebugMode) {
        this.currentDebugMode = currentDebugMode;
    }

    public void handleEvent(RaveEvent event) {
        if (event instanceof PortalPreferenceJavascriptDebugModeSaveEvent) {
            this.setCurrentDebugMode(String.valueOf(this.portalPreferenceService.getPreference("javaScriptDebugMode").getValue()));
            log.debug((Object)("found event to change debug mode of JS new value =" + this.getCurrentDebugMode()));
            this.registerScriptBlock();
        } else {
            log.warn((Object)("Unhandled event received. " + event.getClass()));
        }
    }

    private void registerScriptBlock() {
        this.scriptManager.registerScriptBlock(CONTAINER_JS_KEY, String.format(SCRIPT_TEMPLATE, this.engineProtocol, this.engineRoot, this.engineGadgetPath, this.containerFeatures, this.getCurrentDebugMode()), ScriptLocation.BEFORE_RAVE);
    }
}

