/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.provider.opensocial.repository.impl;

import java.util.Iterator;
import org.apache.rave.provider.opensocial.Constants;
import org.apache.rave.provider.opensocial.repository.GadgetMetadataRepository;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;
import org.springframework.web.client.RestOperations;

@Repository
public class ShindigGadgetMetadataRepository
implements GadgetMetadataRepository {
    private static Logger logger = LoggerFactory.getLogger(ShindigGadgetMetadataRepository.class);
    private RestOperations restOperations;
    private String shindigUrl;

    @Autowired
    public ShindigGadgetMetadataRepository(@Qualifier(value="jsonStringCompatibleRestTemplate") RestOperations restOperations, @Value(value="${portal.opensocial_engine.protocol}") String shindigProtocol, @Value(value="${portal.opensocial_engine.root}") String shindigRoot) {
        this.restOperations = restOperations;
        this.shindigUrl = shindigProtocol + "://" + shindigRoot + "/rpc";
        logger.debug("Shindig render Url: " + this.shindigUrl);
    }

    @Override
    public String getGadgetMetadata(String gadgetUrl) {
        JSONArray rpcArray = new JSONArray();
        try {
            JSONObject fetchMetadataRpcOperation = new JSONObject().put("method", (Object)"gadgets.metadata").put("id", (Object)"gadgets.metadata").put("params", (Object)new JSONObject().put("container", (Object)"default").append("ids", (Object)gadgetUrl).append("fields", (Object)"iframeUrls").append("fields", (Object)"modulePrefs.*").append("fields", (Object)"needsTokenRefresh").append("fields", (Object)"userPrefs.*").append("fields", (Object)"views.preferredHeight").append("fields", (Object)"views.preferredWidth").append("fields", (Object)"expireTimeMs").append("fields", (Object)"responseTimeMs").put("userId", (Object)"@viewer").put("groupId", (Object)"@self"));
            rpcArray.put((Object)fetchMetadataRpcOperation);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Error occurred while generating data for shindig metadata call", e);
        }
        String postData = rpcArray.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("requestContent: {}", (Object)postData);
        }
        String responseString = (String)this.restOperations.postForObject(this.shindigUrl, (Object)postData, String.class, new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("shindig metadata raw response: {}", (Object)responseString);
        }
        try {
            JSONObject responseObject = new JSONArray(responseString).getJSONObject(0).getJSONObject("result").getJSONObject(gadgetUrl);
            boolean hasPrefsToEdit = false;
            if (responseObject.has("userPrefs")) {
                JSONObject userPrefs = responseObject.getJSONObject("userPrefs");
                Iterator keys = userPrefs.keys();
                while (keys.hasNext()) {
                    String userPrefName = (String)keys.next();
                    JSONObject userPref = userPrefs.getJSONObject(userPrefName);
                    if (Constants.PrefDataTypes.HIDDEN.toString().equals(userPref.getString("dataType"))) continue;
                    hasPrefsToEdit = true;
                    break;
                }
            }
            responseObject.put("hasPrefsToEdit", hasPrefsToEdit);
            responseString = responseObject.toString();
            if (logger.isDebugEnabled()) {
                logger.debug("shindig metadata trimmed response: {}", (Object)responseString);
            }
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Error occurred while processing response from shindig metadata call", e);
        }
        return responseString;
    }
}

