/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.gadgets.oauth.inject;

import java.io.IOException;
import java.io.InputStream;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthServiceProvider;
import org.apache.commons.io.IOUtils;
import org.apache.rave.gadgets.oauth.service.OAuthConsumerStoreService;
import org.apache.rave.gadgets.oauth.service.OAuthTokenInfoService;
import org.apache.rave.model.OAuthConsumerStore;
import org.apache.rave.model.OAuthTokenInfo;
import org.apache.rave.portal.model.impl.OAuthTokenInfoImpl;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.oauth.BasicOAuthStore;
import org.apache.shindig.gadgets.oauth.BasicOAuthStoreConsumerKeyAndSecret;
import org.apache.shindig.gadgets.oauth.OAuthStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;

public class DefaultOAuthStore
implements OAuthStore {
    @Autowired
    private OAuthConsumerStoreService consumerStoreService;
    @Autowired
    private OAuthTokenInfoService tokenInfoService;
    private String defaultCallbackUrl;
    private BasicOAuthStoreConsumerKeyAndSecret defaultKey;

    public DefaultOAuthStore(String defaultCallbackUrl, String pathToPrivateKey, String privateKeyName) throws IOException {
        this.defaultCallbackUrl = defaultCallbackUrl;
        this.defaultKey = DefaultOAuthStore.loadDefaultKey(pathToPrivateKey, privateKeyName);
    }

    public OAuthStore.ConsumerInfo getConsumerKeyAndSecret(SecurityToken securityToken, String serviceName, OAuthServiceProvider provider) throws GadgetException {
        String gadgetUri = securityToken.getAppUrl();
        OAuthConsumerStore consumerStore = this.consumerStoreService.findByUriAndServiceName(gadgetUri, serviceName);
        if (consumerStore == null) {
            return null;
        }
        OAuthConsumer consumer = this.createOAuthConsumer(provider, consumerStore);
        String callbackUrl = consumerStore.getCallbackUrl() != null ? consumerStore.getCallbackUrl() : this.defaultCallbackUrl;
        return new OAuthStore.ConsumerInfo(consumer, consumerStore.getKeyName(), callbackUrl);
    }

    public OAuthStore.TokenInfo getTokenInfo(SecurityToken securityToken, OAuthStore.ConsumerInfo consumerInfo, String serviceName, String tokenName) throws GadgetException {
        OAuthTokenInfo oAuthTokenInfo = this.tokenInfoService.findOAuthTokenInfo(securityToken.getViewerId(), securityToken.getAppUrl(), "NOT_USED", tokenName, serviceName);
        if (oAuthTokenInfo == null) {
            return null;
        }
        return new OAuthStore.TokenInfo(oAuthTokenInfo.getAccessToken(), oAuthTokenInfo.getTokenSecret(), oAuthTokenInfo.getSessionHandle(), oAuthTokenInfo.getTokenExpireMillis());
    }

    public void setTokenInfo(SecurityToken securityToken, OAuthStore.ConsumerInfo consumerInfo, String serviceName, String tokenName, OAuthStore.TokenInfo tokenInfo) throws GadgetException {
        OAuthTokenInfoImpl oAuthTokenInfo = new OAuthTokenInfoImpl(securityToken.getAppUrl(), serviceName, tokenName, tokenInfo.getAccessToken(), tokenInfo.getSessionHandle(), tokenInfo.getTokenSecret(), securityToken.getViewerId(), tokenInfo.getTokenExpireMillis());
        this.tokenInfoService.saveOAuthTokenInfo((OAuthTokenInfo)oAuthTokenInfo);
    }

    public void removeToken(SecurityToken securityToken, OAuthStore.ConsumerInfo consumerInfo, String serviceName, String tokenName) throws GadgetException {
        this.tokenInfoService.deleteOAuthTokenInfo(securityToken.getViewerId(), securityToken.getAppUrl(), "NOT_USED", tokenName, serviceName);
    }

    private OAuthConsumer createOAuthConsumer(OAuthServiceProvider provider, OAuthConsumerStore consumerStore) {
        OAuthConsumer consumer;
        String consumerKey = consumerStore.getConsumerKey();
        String consumerSecret = consumerStore.getConsumerSecret();
        switch (consumerStore.getKeyType()) {
            case RSA_PRIVATE: {
                consumer = new OAuthConsumer(null, consumerKey, null, provider);
                consumer.setProperty("oauth_signature_method", (Object)"RSA-SHA1");
                consumer.setProperty("RSA-SHA1.PrivateKey", (Object)this.defaultKey.getConsumerSecret());
                break;
            }
            case HMAC_SYMMETRIC: {
                consumer = new OAuthConsumer(null, consumerKey, consumerSecret, provider);
                consumer.setProperty("oauth_signature_method", (Object)"HMAC-SHA1");
                break;
            }
            case PLAINTEXT: {
                consumer = new OAuthConsumer(null, consumerKey, consumerSecret, provider);
                consumer.setProperty("oauth_signature_method", (Object)"PLAINTEXT");
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot handle keytype " + consumerStore.getKeyType());
            }
        }
        return consumer;
    }

    static BasicOAuthStoreConsumerKeyAndSecret loadDefaultKey(String signingKeyFile, String signingKeyName) throws IOException {
        InputStream inputStream = new ClassPathResource(signingKeyFile).getInputStream();
        String privateKey = IOUtils.toString((InputStream)inputStream);
        privateKey = BasicOAuthStore.convertFromOpenSsl((String)privateKey);
        return new BasicOAuthStoreConsumerKeyAndSecret(null, privateKey, BasicOAuthStoreConsumerKeyAndSecret.KeyType.RSA_PRIVATE, signingKeyName, null);
    }
}

