/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.gadgets.oauth.service.impl;

import org.apache.rave.gadgets.oauth.service.OAuthTokenInfoService;
import org.apache.rave.model.OAuthTokenInfo;
import org.apache.rave.portal.repository.OAuthTokenInfoRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultOAuthTokenInfoService
implements OAuthTokenInfoService {
    private final OAuthTokenInfoRepository repository;

    @Autowired
    public DefaultOAuthTokenInfoService(OAuthTokenInfoRepository repository) {
        this.repository = repository;
    }

    @Override
    public OAuthTokenInfo findOAuthTokenInfo(String userId, String appUrl, String moduleId, String tokenName, String serviceName) {
        return this.repository.findOAuthTokenInfo(userId, appUrl, moduleId, tokenName, serviceName);
    }

    @Override
    public OAuthTokenInfo saveOAuthTokenInfo(OAuthTokenInfo tokenInfo) {
        return (OAuthTokenInfo)this.repository.save((Object)tokenInfo);
    }

    @Override
    @Transactional
    public void deleteOAuthTokenInfo(String userId, String appUrl, String moduleId, String tokenName, String serviceName) {
        OAuthTokenInfo oAuthTokenInfo = this.findOAuthTokenInfo(userId, appUrl, moduleId, tokenName, serviceName);
        if (oAuthTokenInfo != null) {
            this.repository.delete((Object)oAuthTokenInfo);
        }
    }
}

