/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.inject;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Collection;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.apache.shindig.common.servlet.GuiceServletContextListener;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public class GuiceBindingSpringContextLoaderListener
extends ContextLoaderListener {
    public void contextInitialized(ServletContextEvent event) {
        super.contextInitialized(event);
        ServletContext servletContext = event.getServletContext();
        Collection<Module> modules = GuiceBindingSpringContextLoaderListener.getModulesFromApplicationContext();
        GuiceBindingSpringContextLoaderListener.overrideInjector(Guice.createInjector(modules), servletContext);
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        Injector injector = (Injector)context.getAttribute("guice-injector");
        if (injector != null) {
            GuiceServletContextListener.CleanupHandler cleanups = (GuiceServletContextListener.CleanupHandler)injector.getInstance(GuiceServletContextListener.CleanupHandler.class);
            cleanups.cleanup();
        }
        context.removeAttribute("guice-injector");
    }

    private static void overrideInjector(Injector injector, ServletContext context) {
        context.setAttribute("guice-injector", (Object)injector);
    }

    private static Collection<Module> getModulesFromApplicationContext() {
        WebApplicationContext context = GuiceBindingSpringContextLoaderListener.getCurrentWebApplicationContext();
        return context.getBeansOfType(Module.class).values();
    }
}

