/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.inject;

import com.google.inject.AbstractModule;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.rave.inject.SpringContextProvider;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringBindingModule
extends AbstractModule
implements ApplicationContextAware {
    public static final String BASE_PACKAGE = "${shindig.spring.base-package}";
    public static final String DELEMITER = ":";
    private ApplicationContext applicationContext;
    private List<String> basePackages;
    private Set<Class<?>> mappedClasses;

    protected void configure() {
        this.mappedClasses = new HashSet();
        this.bindFromApplicationContext();
    }

    @Value(value="${shindig.spring.base-package}")
    public void setBasePackage(String value) {
        String replace = value.replace(".", "\\.");
        this.basePackages = Arrays.asList(replace.split(DELEMITER));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private void bindFromApplicationContext() {
        for (String beanName : this.applicationContext.getBeanDefinitionNames()) {
            Object bean = this.applicationContext.getBean(beanName);
            if (bean == null) continue;
            this.bindInterfaces(bean);
        }
    }

    private void bindInterfaces(Object bean) {
        String fullClassName;
        String string = fullClassName = Proxy.isProxyClass(bean.getClass()) ? bean.toString() : bean.getClass().getName();
        if (this.isAddable(fullClassName)) {
            for (Class<?> clazz : bean.getClass().getInterfaces()) {
                if (this.mappedClasses.contains(clazz)) continue;
                this.bind(clazz).toProvider(new SpringContextProvider(clazz, this.applicationContext));
                this.mappedClasses.add(clazz);
            }
        }
    }

    private boolean isAddable(String fullClassName) {
        for (String basePackage : this.basePackages) {
            if (!fullClassName.matches(basePackage + ".*")) continue;
            return true;
        }
        return false;
    }
}

