/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.opensocial.service.impl;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.apache.rave.model.ActivityStreamsEntry;
import org.apache.rave.model.ActivityStreamsMediaLink;
import org.apache.rave.model.ActivityStreamsObject;
import org.apache.rave.portal.model.impl.ActivityStreamsEntryImpl;
import org.apache.rave.portal.model.impl.ActivityStreamsMediaLinkImpl;
import org.apache.rave.portal.repository.ActivityStreamsRepository;
import org.apache.rave.util.ActivityConversionUtil;
import org.apache.shindig.auth.BasicSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.protocol.model.SortOrder;
import org.apache.shindig.social.core.model.ActivityEntryImpl;
import org.apache.shindig.social.opensocial.model.ActivityEntry;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.spi.ActivityStreamService;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultActivityStreamsService
implements ActivityStreamService {
    public static final String OBJECT_TYPE_PERSON = "person";
    @Autowired
    private ActivityStreamsRepository repository;
    private PersonService personService;
    private static Logger log = Logger.getLogger(DefaultActivityStreamsService.class.getName());
    private static ActivityConversionUtil converter = new ActivityConversionUtil();

    @Autowired
    public DefaultActivityStreamsService(ActivityStreamsRepository repository, PersonService personService) {
        this.repository = repository;
        this.personService = personService;
    }

    public Future<RestfulCollection<ActivityEntry>> getActivityEntries(Set<UserId> userIds, GroupId groupId, String appId, Set<String> fields, CollectionOptions options, SecurityToken token) {
        List<ActivityEntry> result = this.getFromRepository(userIds, groupId, appId, fields, options, token);
        return Futures.immediateFuture((Object)new RestfulCollection(result));
    }

    public Future<RestfulCollection<ActivityEntry>> getActivityEntries(UserId userId, GroupId groupId, String appId, Set<String> fields, CollectionOptions options, Set<String> activityIds, SecurityToken token) throws ProtocolException {
        LinkedList entries = Lists.newLinkedList();
        HashMap peopleById = Maps.newHashMap();
        for (String id : activityIds) {
            entries.add(this.getActivity(fields, userId.getUserId(token), peopleById, id));
        }
        return Futures.immediateFuture((Object)new RestfulCollection((List)entries));
    }

    public Future<ActivityEntry> getActivityEntry(UserId userId, GroupId groupId, String appId, Set<String> fields, String activityId, SecurityToken token) throws ProtocolException {
        return Futures.immediateFuture((Object)this.getActivity(fields, userId.getUserId(token), Maps.newHashMap(), activityId));
    }

    public Future<Void> deleteActivityEntries(UserId userId, GroupId groupId, String appId, Set<String> activityIds, SecurityToken token) throws ProtocolException {
        String uid = userId.getUserId(token);
        for (String id : activityIds) {
            ActivityStreamsEntry activity = (ActivityStreamsEntry)this.repository.get(id);
            if (activity == null || !activity.getUserId().equalsIgnoreCase(uid)) continue;
            this.repository.delete((Object)activity);
        }
        return Futures.immediateFuture(null);
    }

    public Future<ActivityEntry> updateActivityEntry(UserId userId, GroupId groupId, String appId, Set<String> fields, ActivityEntry activity, String activityId, SecurityToken token) throws ProtocolException {
        String uid = userId.getUserId(token);
        if (activityId == null) {
            if (activity.getId() == null) {
                return null;
            }
            activityId = activity.getId();
        } else if (activity.getId() == null) {
            activity.setId(activityId);
        } else if (!activity.getId().equalsIgnoreCase(activityId)) {
            return null;
        }
        ActivityStreamsEntryImpl tmp = converter.convert(activity);
        tmp.setUserId(uid);
        tmp.setGroupId(groupId.getObjectId().toString());
        tmp.setAppId(appId);
        ActivityStreamsEntry saved = (ActivityStreamsEntry)this.repository.save((Object)tmp);
        ActivityEntryImpl impl = converter.convert(saved);
        return Futures.immediateFuture((Object)impl);
    }

    public Future<ActivityEntry> createActivityEntry(UserId userId, GroupId groupId, String appId, Set<String> fields, ActivityEntry activity, SecurityToken token) throws ProtocolException {
        String uid = userId.getUserId(token);
        ActivityStreamsEntryImpl activityEntity = converter.convert(activity);
        ActivityStreamsEntry saved = (ActivityStreamsEntry)this.repository.save((Object)activityEntity);
        return Futures.immediateFuture((Object)converter.convert(saved));
    }

    public void process(Object input) {
        if (input instanceof ArrayList) {
            ArrayList activities = (ArrayList)input;
            for (ActivityStreamsEntryImpl activity : activities) {
                this.repository.save((Object)activity);
            }
        }
    }

    public Collection<? extends ActivityEntry> getContent() {
        return converter.convert(this.repository.getAll());
    }

    public Set<String> getIdSet(Set<UserId> users, GroupId group, SecurityToken token) {
        LinkedHashSet ids = Sets.newLinkedHashSet();
        for (UserId user : users) {
            ids.addAll(this.getIdSet(user, group, token));
        }
        return ids;
    }

    private ActivityEntry getActivity(Set<String> fields, String uid, Map<String, Person> peopleById, String id) {
        ActivityStreamsEntry entry = (ActivityStreamsEntry)this.repository.get(id);
        if (entry != null && entry.getUserId().equalsIgnoreCase(uid)) {
            this.populatePersonObjects(entry, peopleById);
            return this.filterFields(entry, fields);
        }
        return null;
    }

    private Set<String> getIdSet(UserId user, GroupId group, SecurityToken token) {
        String userId = user.getUserId(token);
        if (group == null) {
            return ImmutableSortedSet.of((Comparable)((Object)userId));
        }
        LinkedHashSet returnVal = Sets.newLinkedHashSet();
        returnVal.add(userId);
        HashSet<UserId> userIdSortedSet = new HashSet<UserId>();
        userIdSortedSet.add(user);
        try {
            List people = ((RestfulCollection)this.personService.getPeople(userIdSortedSet, group, null, (Set)returnVal, token).get()).getList();
            for (Person p : people) {
                returnVal.add(p.getId());
            }
        }
        catch (InterruptedException e) {
            log.info("request interrupted " + e);
        }
        catch (ExecutionException x) {
            log.info("execution exception " + x);
        }
        catch (Exception e) {
            log.info("problem: " + e);
        }
        return returnVal;
    }

    private ActivityEntry filterFields(ActivityStreamsEntry entry, Set<String> fields) {
        return converter.convert(entry);
    }

    private List<ActivityEntry> getFromRepository(Set<UserId> userIds, GroupId groupId, String appId, Set<String> fields, CollectionOptions options, SecurityToken token) {
        ArrayList result = Lists.newArrayList();
        HashMap peopleById = Maps.newHashMap();
        Set<String> idSet = this.getIdSet(userIds, groupId, token);
        for (String id : idSet) {
            List entries = this.repository.getByUserId(id);
            if (entries == null) continue;
            result.addAll(this.populateActivityEntries(entries, peopleById));
        }
        this.sortByPublished(result, options == null ? null : options.getSortOrder());
        return this.convert(result);
    }

    private List<ActivityStreamsEntry> populateActivityEntries(List<ActivityStreamsEntry> entries, Map<String, Person> peopleById) {
        for (ActivityStreamsEntry entry : entries) {
            this.populatePersonObjects(entry, peopleById);
        }
        return entries;
    }

    private void sortByPublished(List<ActivityStreamsEntry> result, final SortOrder order) {
        Collections.sort(result, new Comparator<ActivityStreamsEntry>(){

            @Override
            public int compare(ActivityStreamsEntry one, ActivityStreamsEntry two) {
                Date publishedOne = one.getPublished();
                Date publishedTwo = two.getPublished();
                if (publishedOne == null) {
                    return publishedTwo == null ? 0 : -1;
                }
                if (publishedTwo == null) {
                    return 1;
                }
                return order != null && order == SortOrder.descending ? publishedOne.compareTo(publishedTwo) : publishedTwo.compareTo(publishedOne);
            }
        });
    }

    private List<ActivityEntry> convert(List<ActivityStreamsEntry> result) {
        ArrayList converted = Lists.newArrayList();
        for (ActivityStreamsEntry entry : result) {
            converted.add(converter.convert(entry));
        }
        return converted;
    }

    private void populatePersonObjects(ActivityStreamsEntry entry, Map<String, Person> peopleById) {
        ActivityStreamsObject actor = entry.getActor();
        if (entry.getActor() != null && OBJECT_TYPE_PERSON.equals(actor.getObjectType())) {
            this.populatePerson(peopleById, actor);
        }
        if (entry.getObject() != null && OBJECT_TYPE_PERSON.equals(entry.getObject().getObjectType())) {
            this.populatePerson(peopleById, entry.getObject());
        }
        if (entry.getTarget() != null && OBJECT_TYPE_PERSON.equals(entry.getTarget().getObjectType())) {
            this.populatePerson(peopleById, entry.getTarget());
        }
    }

    private void populatePerson(Map<String, Person> peopleById, ActivityStreamsObject actor) {
        Person person;
        String id = actor.getId();
        Person person2 = person = peopleById.containsKey(id) ? peopleById.get(id) : this.getPerson(id);
        if (person != null) {
            peopleById.put(id, person);
            actor.setUrl(person.getProfileUrl());
            actor.setDisplayName(person.getDisplayName());
            ActivityStreamsMediaLinkImpl image = new ActivityStreamsMediaLinkImpl();
            image.setUrl(person.getThumbnailUrl());
            actor.setImage((ActivityStreamsMediaLink)image);
        }
    }

    private Person getPerson(String id) {
        Person person;
        BasicSecurityToken token = new BasicSecurityToken(null, id, null, null, null, null, null, null, null);
        try {
            person = (Person)this.personService.getPerson(new UserId(UserId.Type.viewer, id), null, (SecurityToken)token).get();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to retrieve person", e);
        }
        return person;
    }

    public ActivityStreamsRepository getRepository() {
        return this.repository;
    }

    public void setRepository(ActivityStreamsRepository repository) {
        this.repository = repository;
    }
}

