/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.opensocial.service.impl;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.StringUtils;
import org.apache.rave.model.ApplicationData;
import org.apache.rave.model.Person;
import org.apache.rave.opensocial.service.SimplePersonService;
import org.apache.rave.portal.model.impl.ApplicationDataImpl;
import org.apache.rave.portal.repository.ApplicationDataRepository;
import org.apache.rave.service.LockService;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.protocol.DataCollection;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.social.opensocial.spi.AppDataService;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultAppDataService
implements AppDataService {
    private final SimplePersonService personService;
    private final LockService lockService;
    private final ApplicationDataRepository applicationDataRepository;

    @Autowired
    public DefaultAppDataService(SimplePersonService personService, LockService lockService, ApplicationDataRepository applicationDataRepository) {
        this.personService = personService;
        this.lockService = lockService;
        this.applicationDataRepository = applicationDataRepository;
    }

    public Future<DataCollection> getPersonData(Set<UserId> userIds, GroupId groupId, String appId, Set<String> fields, SecurityToken token) throws ProtocolException {
        List<String> personIds = this.validateReadRequest(userIds, groupId, appId, token);
        List applicationData = this.applicationDataRepository.getApplicationData(personIds, appId);
        DataCollection dataCollection = this.convertAppDataMapToDataCollection(personIds, applicationData, fields);
        return Futures.immediateFuture((Object)dataCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> deletePersonData(UserId userId, GroupId groupId, String appId, Set<String> fields, SecurityToken token) throws ProtocolException {
        String personId = this.validateWriteRequest(userId, groupId, appId, token);
        Lock lock = this.getApplicationDataLock(personId, appId);
        try {
            lock.lock();
            ApplicationData applicationData = this.applicationDataRepository.getApplicationData(personId, appId);
            if (applicationData == null || applicationData.getData() == null) {
                ListenableFuture listenableFuture = Futures.immediateFuture(null);
                return listenableFuture;
            }
            Map data = applicationData.getData();
            if (fields == null || fields.size() == 0) {
                data.clear();
            } else {
                data.keySet().removeAll(fields);
            }
            this.applicationDataRepository.save((Object)applicationData);
        }
        finally {
            lock.unlock();
            this.lockService.returnLock(lock);
        }
        return Futures.immediateFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> updatePersonData(UserId userId, GroupId groupId, String appId, Set<String> fields, Map<String, Object> values, SecurityToken token) throws ProtocolException {
        String personId = this.validateWriteRequest(userId, groupId, appId, token);
        Lock lock = this.getApplicationDataLock(personId, appId);
        try {
            lock.lock();
            ApplicationData applicationData = this.applicationDataRepository.getApplicationData(personId, appId);
            if (applicationData == null) {
                applicationData = new ApplicationDataImpl(null, personId, appId, new HashMap());
            }
            if (fields == null || fields.size() == 0) {
                applicationData.setData(values);
            } else {
                if (!fields.containsAll(values.keySet())) {
                    throw new ProtocolException(400, "Fields parameter must either be empty or contain keys for all name value pairs sent in request.");
                }
                Map data = applicationData.getData();
                for (String field : fields) {
                    if (!values.containsKey(field)) {
                        data.remove(field);
                        continue;
                    }
                    data.put(field, values.get(field));
                }
            }
            this.applicationDataRepository.save((Object)applicationData);
        }
        finally {
            lock.unlock();
            this.lockService.returnLock(lock);
        }
        return Futures.immediateFuture(null);
    }

    private List<String> validateReadRequest(Set<UserId> userIds, GroupId groupId, String appId, SecurityToken token) {
        this.validateAppIdMatches(appId, token);
        List<Person> people = this.personService.getPeople(userIds, groupId, null, token);
        return this.convertPeopleToUserIds(people);
    }

    private String validateWriteRequest(UserId userId, GroupId groupId, String appId, SecurityToken token) {
        HashSet<UserId> userIds = new HashSet<UserId>(Arrays.asList(userId));
        List<String> personIds = this.validateReadRequest(userIds, groupId, appId, token);
        if (personIds.size() != 1 || !personIds.get(0).equalsIgnoreCase(token.getViewerId())) {
            throw new ProtocolException(400, "Writing appdata for anyone but the current viewer is forbidden.");
        }
        return personIds.get(0);
    }

    private void validateAppIdMatches(String appId, SecurityToken token) {
        if (StringUtils.isBlank((CharSequence)appId) || !appId.equalsIgnoreCase(token.getAppId())) {
            throw new ProtocolException(400, "Requesting appdata for a different application is forbidden.");
        }
    }

    private List<String> convertPeopleToUserIds(List<Person> people) {
        ArrayList<String> ids = new ArrayList<String>(people.size());
        for (Person person : people) {
            ids.add(String.valueOf(person.getUsername()));
        }
        return ids;
    }

    private Lock getApplicationDataLock(String personId, String appId) {
        return this.lockService.borrowLock("ApplicationData", personId + "-" + appId);
    }

    private DataCollection convertAppDataMapToDataCollection(List<String> personIds, List<ApplicationData> applicationData, Set<String> fields) {
        HashMap dataCollectionMap = new HashMap();
        for (ApplicationData data : applicationData) {
            HashMap returnData = new HashMap();
            if (fields == null || fields.size() == 0) {
                returnData.putAll(data.getData());
            } else {
                for (Map.Entry userDataEntry : data.getData().entrySet()) {
                    if (!fields.contains(userDataEntry.getKey())) continue;
                    returnData.put(userDataEntry.getKey(), userDataEntry.getValue());
                }
            }
            dataCollectionMap.put(data.getUserId(), returnData);
        }
        for (String personId : personIds) {
            if (dataCollectionMap.containsKey(personId)) continue;
            dataCollectionMap.put(personId, new HashMap());
        }
        return new DataCollection(dataCollectionMap);
    }
}

