/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rave.model.ActivityStreamsEntry;
import org.apache.rave.model.ActivityStreamsItem;
import org.apache.rave.model.ActivityStreamsMediaLink;
import org.apache.rave.model.ActivityStreamsObject;
import org.apache.rave.portal.model.impl.ActivityStreamsEntryImpl;
import org.apache.rave.portal.model.impl.ActivityStreamsMediaLinkImpl;
import org.apache.rave.portal.model.impl.ActivityStreamsObjectImpl;
import org.apache.rave.portal.util.ModelUtil;
import org.apache.shindig.protocol.model.ExtendableBean;
import org.apache.shindig.protocol.model.ExtendableBeanImpl;
import org.apache.shindig.social.core.model.ActivityEntryImpl;
import org.apache.shindig.social.core.model.ActivityObjectImpl;
import org.apache.shindig.social.core.model.MediaLinkImpl;
import org.apache.shindig.social.opensocial.model.ActivityEntry;
import org.apache.shindig.social.opensocial.model.ActivityObject;
import org.apache.shindig.social.opensocial.model.MediaLink;

public class ActivityConversionUtil {
    public List<ActivityEntry> convert(Collection<? extends ActivityStreamsEntry> all) {
        if (all == null) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (ActivityStreamsEntry activityStreamsEntry : all) {
            list.add(this.convert(activityStreamsEntry));
        }
        return list;
    }

    public List<ActivityStreamsObject> convertObjectEntries(Collection<ActivityObject> all) {
        if (all == null) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (ActivityObject entry : all) {
            list.add(this.convert(entry));
        }
        return list;
    }

    public ActivityEntryImpl convert(ActivityStreamsEntry saved) {
        if (saved == null) {
            return null;
        }
        ActivityEntryImpl impl = new ActivityEntryImpl();
        impl.setActor(this.convert(saved.getActor()));
        impl.setContent(saved.getContent());
        impl.setExtensions(this.convert(saved.getExtensions()));
        impl.setGenerator(this.convert(saved.getGenerator()));
        impl.setIcon(this.convert(saved.getIcon()));
        impl.setId(saved.getId());
        impl.setObject(this.convert(saved.getObject()));
        impl.setOpenSocial(this.convert(saved.getOpenSocial()));
        impl.setProvider(this.convert(saved.getProvider()));
        impl.setPublished(ModelUtil.dateToString((Date)saved.getPublished()));
        impl.setTarget(this.convert(saved.getTarget()));
        impl.setUpdated(ModelUtil.dateToString((Date)saved.getUpdated()));
        impl.setTitle(saved.getTitle());
        impl.setUrl(saved.getUrl());
        impl.setVerb(saved.getVerb());
        return impl;
    }

    public ActivityObject convert(ActivityStreamsObject object) {
        if (object == null) {
            return null;
        }
        ActivityObjectImpl impl = new ActivityObjectImpl();
        impl.setAttachments(this.convert(object.getAttachments()));
        impl.setAuthor(this.convert(object.getAuthor()));
        impl.setContent(object.getContent());
        impl.setDisplayName(object.getDisplayName());
        impl.setDownstreamDuplicates(object.getDownstreamDuplicates());
        impl.setId(object.getId());
        impl.setImage(this.convert(object.getImage()));
        impl.setObjectType(object.getObjectType());
        impl.setPublished(ModelUtil.dateToString((Date)object.getPublished()));
        impl.setSummary(object.getSummary());
        impl.setUpdated(ModelUtil.dateToString((Date)object.getUpdated()));
        impl.setUpstreamDuplicates(object.getUpstreamDuplicates());
        impl.setUrl(object.getUrl());
        impl.setOpenSocial(this.convert(object.getOpenSocial()));
        return impl;
    }

    public ActivityObject convert(ActivityStreamsItem object) {
        if (object instanceof ActivityStreamsObject) {
            return this.convert((ActivityStreamsObject)object);
        }
        return null;
    }

    public List<ActivityObject> convert(List<? extends ActivityStreamsObject> attachments) {
        if (attachments == null) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (ActivityStreamsObject activityStreamsObject : attachments) {
            list.add(this.convert(activityStreamsObject));
        }
        return list;
    }

    public ActivityStreamsEntryImpl convert(ActivityEntry activity) {
        ActivityStreamsEntryImpl entity = new ActivityStreamsEntryImpl();
        if (activity.getActor() != null) {
            entity.setActor(this.convert(activity.getActor()));
        }
        if (activity.getContent() != null) {
            entity.setContent(activity.getContent());
        }
        if (activity.getGenerator() != null) {
            entity.setGenerator(this.convert(activity.getGenerator()));
        }
        if (activity.getIcon() != null) {
            entity.setIcon(this.convert(activity.getIcon()));
        }
        if (activity.getId() != null) {
            entity.setId(activity.getId());
        }
        if (activity.getObject() != null) {
            entity.setObject(this.convert(activity.getObject()));
        }
        if (activity.getPublished() != null) {
            entity.setPublished(ModelUtil.stringToDate((String)activity.getPublished()));
        }
        if (activity.getProvider() != null) {
            entity.setProvider(this.convert(activity.getProvider()));
        }
        if (activity.getTarget() != null) {
            entity.setTarget(this.convert(activity.getTarget()));
        }
        if (activity.getTitle() != null) {
            entity.setTitle(activity.getTitle());
        }
        if (activity.getUpdated() != null) {
            entity.setUpdated(ModelUtil.stringToDate((String)activity.getUpdated()));
        }
        if (activity.getUrl() != null) {
            entity.setUrl(activity.getUrl());
        }
        if (activity.getVerb() != null) {
            entity.setVerb(activity.getVerb());
        }
        if (activity.getOpenSocial() != null) {
            entity.setOpenSocial(this.convert(activity.getOpenSocial()));
        }
        if (activity.getExtensions() != null) {
            entity.setExtensions(this.convert(activity.getExtensions()));
        }
        return entity;
    }

    public ActivityStreamsObject convert(ActivityObject object) {
        ActivityStreamsObjectImpl entity = new ActivityStreamsObjectImpl();
        if (object.getAuthor() != null) {
            entity.setAuthor(this.convert(object.getAuthor()));
        }
        if (object.getAttachments() != null) {
            entity.setAttachments(this.convertObjectEntries(object.getAttachments()));
        }
        if (object.getContent() != null) {
            entity.setContent(object.getContent());
        }
        if (object.getDisplayName() != null) {
            entity.setDisplayName(object.getDisplayName());
        }
        if (object.getDownstreamDuplicates() != null) {
            entity.setDownstreamDuplicates(object.getDownstreamDuplicates());
        }
        if (object.getId() != null) {
            entity.setId(object.getId());
        }
        if (object.getImage() != null) {
            entity.setImage(this.convert(object.getImage()));
        }
        if (object.getObjectType() != null) {
            entity.setObjectType(object.getObjectType());
        }
        if (object.getPublished() != null) {
            entity.setPublished(ModelUtil.stringToDate((String)object.getPublished()));
        }
        if (object.getSummary() != null) {
            entity.setSummary(object.getSummary());
        }
        if (object.getUpdated() != null) {
            entity.setUpdated(ModelUtil.stringToDate((String)object.getUpdated()));
        }
        if (object.getUpstreamDuplicates() != null) {
            entity.setUpstreamDuplicates(object.getUpstreamDuplicates());
        }
        if (object.getUrl() != null) {
            entity.setUrl(object.getUrl());
        }
        if (object.getOpenSocial() != null) {
            entity.setOpenSocial(this.convert(object.getOpenSocial()));
        }
        return entity;
    }

    public ActivityStreamsMediaLink convert(MediaLink icon) {
        if (icon == null) {
            return null;
        }
        ActivityStreamsMediaLinkImpl entity = new ActivityStreamsMediaLinkImpl();
        entity.setDuration(icon.getDuration());
        entity.setHeight(icon.getHeight());
        entity.setOpenSocial(this.convert(icon.getOpenSocial()));
        entity.setUrl(icon.getUrl());
        entity.setWidth(icon.getWidth());
        return entity;
    }

    public MediaLink convert(ActivityStreamsMediaLink icon) {
        if (icon == null) {
            return null;
        }
        MediaLinkImpl entity = new MediaLinkImpl();
        entity.setDuration(icon.getDuration());
        entity.setHeight(icon.getHeight());
        entity.setOpenSocial(this.convert(icon.getOpenSocial()));
        entity.setUrl(icon.getUrl());
        entity.setWidth(icon.getWidth());
        return entity;
    }

    public Map convert(ExtendableBean bean) {
        if (bean == null) {
            return null;
        }
        HashMap entity = new HashMap();
        entity.putAll(bean);
        return entity;
    }

    public ExtendableBean convert(Map map) {
        if (map == null) {
            return null;
        }
        ExtendableBeanImpl bean = new ExtendableBeanImpl();
        bean.putAll(map);
        return bean;
    }
}

