/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.provider.w3c.service.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.rave.portal.service.WidgetProviderService;
import org.apache.rave.provider.w3c.service.impl.W3CWidget;
import org.apache.wookie.connector.framework.User;
import org.apache.wookie.connector.framework.Widget;
import org.apache.wookie.connector.framework.WidgetInstance;
import org.apache.wookie.connector.framework.WookieConnectorException;
import org.apache.wookie.connector.framework.WookieConnectorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WookieWidgetService
implements WidgetProviderService {
    private static Logger logger = LoggerFactory.getLogger(WookieWidgetService.class);
    private final String wookieServerUrl;
    private final String wookieApiKey;
    private final String adminUsername;
    private final String adminPassword;
    private static WookieConnectorService connectorService;

    public WookieWidgetService(String wookieServerUrl, String wookieApiKey, String adminUsername, String adminPassword) {
        this.wookieServerUrl = wookieServerUrl;
        this.wookieApiKey = wookieApiKey;
        this.adminUsername = adminUsername;
        this.adminPassword = adminPassword;
    }

    public org.apache.rave.model.Widget getWidget(org.apache.rave.model.User viewer, String sharedDataKey, org.apache.rave.model.Widget widget) {
        if (widget.getType().equals("W3C")) {
            return this.getWidgetForViewer(widget, sharedDataKey, viewer);
        }
        return null;
    }

    public org.apache.rave.model.Widget[] getWidgets() throws WookieConnectorException {
        connectorService = this.getWookieConnectorService(this.wookieServerUrl, this.wookieApiKey, null);
        Collection widgets = connectorService.getAvailableWidgets().values();
        ArrayList<W3CWidget> raveWidgets = new ArrayList<W3CWidget>();
        for (Widget wookieWidget : widgets) {
            W3CWidget widget = new W3CWidget();
            widget.setUrl(wookieWidget.getIdentifier());
            widget.setDescription(wookieWidget.getDescription());
            widget.setTitle(wookieWidget.getTitle());
            widget.setThumbnailUrl(wookieWidget.getIcon().toString());
            raveWidgets.add(widget);
        }
        return raveWidgets.toArray(new org.apache.rave.model.Widget[raveWidgets.size()]);
    }

    public org.apache.rave.model.Widget getWidget(String url) throws WookieConnectorException {
        for (org.apache.rave.model.Widget widget : this.getWidgets()) {
            if (!widget.getUrl().equalsIgnoreCase(url)) continue;
            return widget;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.apache.rave.model.Widget publishWidgetUrlToWookie(String widgetStrUrl) {
        W3CWidget widget = null;
        File tempWgtFile = null;
        try {
            if (this.adminUsername.equals(null) || this.adminUsername.equals("") || this.adminPassword.equals(null) || this.adminPassword.equals("")) {
                throw new WookieConnectorException("Either the wookie username or password is not defined in portal.properties", null);
            }
            connectorService = this.getWookieConnectorService(this.wookieServerUrl, this.wookieApiKey, "");
            URL widgetUrl = new URL(widgetStrUrl);
            String tempUploadFolder = System.getProperty("java.io.tmpdir");
            String filename = this.normalizeFileName(widgetUrl);
            tempWgtFile = new File(tempUploadFolder, filename);
            FileUtils.copyURLToFile((URL)widgetUrl, (File)tempWgtFile, (int)10000, (int)10000);
            Widget wookieWidget = connectorService.postWidget(tempWgtFile, this.adminUsername, this.adminPassword);
            widget = new W3CWidget();
            widget.setUrl(wookieWidget.getIdentifier());
            widget.setDescription(wookieWidget.getDescription());
            widget.setTitle(wookieWidget.getTitle());
            widget.setType("W3C");
            widget.setThumbnailUrl(wookieWidget.getIcon().toString());
        }
        catch (WookieConnectorException e) {
            logger.warn(e.getMessage());
            org.apache.rave.model.Widget widget2 = this.returnURLFromConfig(tempWgtFile);
            return widget2;
        }
        catch (MalformedURLException e) {
            logger.error("Malformed url error. " + e.getMessage());
        }
        catch (IOException e) {
            logger.error("I/O error. Problem downloading widget from given URL" + e.getMessage());
        }
        finally {
            if (tempWgtFile.exists()) {
                tempWgtFile.delete();
            }
        }
        return widget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private org.apache.rave.model.Widget returnURLFromConfig(File wgtFile) {
        W3CWidget widget = null;
        try {
            ZipFile zipFile = new ZipFile(wgtFile);
            ZipEntry entry = zipFile.getEntry("config.xml");
            InputStream input = zipFile.getInputStream(entry);
            BufferedReader br = new BufferedReader(new InputStreamReader(input, "UTF-8"));
            try {
                String line = null;
                do {
                    if ((line = br.readLine()) == null) return widget;
                } while (!line.contains("id="));
                String val = line.substring(line.indexOf("id=") + 4, line.indexOf("\"", line.indexOf("id=") + 5));
                widget = new W3CWidget();
                widget.setUrl(val);
                W3CWidget w3CWidget = widget;
                return w3CWidget;
            }
            finally {
                input.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return widget;
    }

    private String normalizeFileName(URL urlPath) {
        String[] parts = urlPath.getFile().split("/");
        String filename = parts[parts.length - 1].length() < 1 ? "unknown.wgt" : parts[parts.length - 1];
        if (filename.indexOf(46) == -1) {
            filename = filename + ".wgt";
        } else if (!filename.endsWith(".wgt")) {
            String[] split = filename.split("\\.");
            filename = split[0] + ".wgt";
        }
        return filename;
    }

    private W3CWidget getWidgetForViewer(org.apache.rave.model.Widget widget, String sharedDataKey, org.apache.rave.model.User viewer) {
        try {
            connectorService = this.getWookieConnectorService(this.wookieServerUrl, this.wookieApiKey, sharedDataKey);
            User user = new User(String.valueOf(viewer.getUsername()), viewer.getUsername());
            connectorService.setCurrentUser(user);
            logger.debug("Getting widget:" + widget.getUrl() + " from:" + connectorService.getConnection().getURL());
            WidgetInstance instance = connectorService.getOrCreateInstance(widget.getUrl());
            return this.createWidget(instance);
        }
        catch (WookieConnectorException e) {
            logger.error("Unable to connect to Wookie server", (Throwable)e);
            return this.createWidget(new WidgetInstance("error", "error", e.getMessage(), "100", "100"));
        }
        catch (IOException e) {
            logger.error("Problem communicating with Wookie server", (Throwable)e);
            return this.createWidget(new WidgetInstance("error", "error", e.getMessage(), "100", "100"));
        }
    }

    private W3CWidget createWidget(WidgetInstance instance) {
        W3CWidget widget = new W3CWidget();
        widget.setUrl(instance.getUrl());
        widget.setTitle(instance.getTitle());
        widget.setType("W3C");
        widget.setHeight(Integer.parseInt(instance.getHeight()));
        widget.setWidth(Integer.parseInt(instance.getWidth()));
        return widget;
    }

    private WookieConnectorService getWookieConnectorService(String serverURL, String apiKey, String sharedDataKey) throws WookieConnectorException {
        connectorService = new WookieConnectorService(serverURL, apiKey, sharedDataKey);
        return connectorService;
    }
}

