/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.provider.w3c.web.renderer;

import org.apache.rave.model.User;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.service.WidgetProviderService;
import org.apache.rave.portal.service.WidgetService;
import org.apache.rave.portal.web.renderer.RegionWidgetRenderer;
import org.apache.rave.portal.web.renderer.model.RenderContext;
import org.apache.rave.provider.w3c.service.impl.W3CWidget;
import org.apache.rave.rest.model.RegionWidget;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class W3cRegionWidgetRenderer
implements RegionWidgetRenderer {
    private final WidgetProviderService widgetService;
    private final UserService userService;
    private final WidgetService coreWidgetService;

    @Autowired
    public W3cRegionWidgetRenderer(@Qualifier(value="wookieWidgetService") WidgetProviderService widgetService, UserService userService, WidgetService coreWidgetService) {
        this.widgetService = widgetService;
        this.userService = userService;
        this.coreWidgetService = coreWidgetService;
    }

    public String getSupportedContext() {
        return "W3C";
    }

    public String render(RegionWidget item, RenderContext context) {
        throw new UnsupportedOperationException();
    }

    public RegionWidget prepareForRender(RegionWidget item) {
        User user = this.userService.getAuthenticatedUser();
        String sharedDataKey = String.valueOf(item.getId());
        W3CWidget contextualizedWidget = (W3CWidget)this.widgetService.getWidget(user, sharedDataKey, this.coreWidgetService.getWidget(item.getWidgetId()));
        item.setWidgetUrl(contextualizedWidget.getUrl());
        return item;
    }
}

