/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.provider.w3c.web.renderer;

import org.apache.rave.exception.NotSupportedException;
import org.apache.rave.model.Page;
import org.apache.rave.model.PageType;
import org.apache.rave.model.RegionWidget;
import org.apache.rave.model.RegionWidgetPreference;
import org.apache.rave.model.User;
import org.apache.rave.model.Widget;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.service.WidgetProviderService;
import org.apache.rave.portal.web.renderer.RegionWidgetWrapperRenderer;
import org.apache.rave.portal.web.renderer.RenderScope;
import org.apache.rave.portal.web.renderer.ScriptLocation;
import org.apache.rave.portal.web.renderer.ScriptManager;
import org.apache.rave.portal.web.renderer.model.RegionWidgetWrapper;
import org.apache.rave.portal.web.renderer.model.RenderContext;
import org.apache.rave.provider.w3c.service.impl.W3CWidget;
import org.apache.rave.util.JsonUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class W3cWidgetWrapperRenderer
implements RegionWidgetWrapperRenderer {
    private static Logger logger = LoggerFactory.getLogger(W3cWidgetWrapperRenderer.class);
    private static final String REGISTER_WIDGET_KEY = "wookieRegisterWidget";
    private final WidgetProviderService widgetService;
    private final UserService userService;
    private ScriptManager scriptManager;
    private static final String SCRIPT_BLOCK = "<script>require(['rave'], function(rave){rave.registerWidget('%1$s', {type: '%2$s', regionWidgetId: %3$s, widgetUrl: '%4$s',  height: '%5$s',  width: '%6$s',  collapsed: %7$s,  widgetId: %8$s,  locked: %9$s,  hideChrome: %10$s,  subPage: {id: %11$s, name: '%12$s', isDefault: %13$s}, properties: %14$s})});</script>";
    private static final String MARKUP = "<!-- RegionWidget %1$s placeholder -->";

    @Autowired
    public W3cWidgetWrapperRenderer(@Qualifier(value="wookieWidgetService") WidgetProviderService widgetService, UserService userService, ScriptManager scriptManager) {
        this.widgetService = widgetService;
        this.userService = userService;
        this.scriptManager = scriptManager;
    }

    public String getSupportedContext() {
        return "W3C";
    }

    public String render(RegionWidgetWrapper wrapper, RenderContext context) {
        Widget widget = wrapper.getWidget();
        RegionWidget item = wrapper.getRegionWidget();
        if (!"W3C".equals(widget.getType())) {
            throw new NotSupportedException("Invalid widget type passed to renderer: " + widget.getType());
        }
        String widgetScript = this.getWidgetScript(item, widget);
        String key = "wookieRegisterWidget-" + item.getId();
        this.scriptManager.registerScriptBlock(key, widgetScript, ScriptLocation.AFTER_RAVE, RenderScope.CURRENT_REQUEST, context);
        logger.debug("Gadget Script Data: " + widgetScript);
        return String.format(MARKUP, item.getId());
    }

    public RegionWidgetWrapper prepareForRender(RegionWidgetWrapper item) {
        throw new UnsupportedOperationException();
    }

    private String getWidgetScript(RegionWidget item, Widget widget) {
        User user = this.userService.getAuthenticatedUser();
        String sharedDataKey = String.valueOf(item.getId());
        W3CWidget contextualizedWidget = (W3CWidget)this.widgetService.getWidget(user, sharedDataKey, widget);
        JSONObject userPrefs = new JSONObject();
        if (item.getPreferences() != null) {
            for (RegionWidgetPreference regionWidgetPreference : item.getPreferences()) {
                try {
                    userPrefs.put(regionWidgetPreference.getName(), (Object)regionWidgetPreference.getValue());
                }
                catch (JSONException e) {
                    logger.error("Exception caught adding preference to JSONObject: " + regionWidgetPreference, (Throwable)e);
                }
            }
        }
        String width = "100%";
        String height = "100%";
        if (contextualizedWidget.getWidth() > 0) {
            width = String.valueOf(contextualizedWidget.getWidth()) + "px";
        }
        if (contextualizedWidget.getHeight() > 0) {
            height = String.valueOf(contextualizedWidget.getHeight()) + "px";
        }
        String pageId = null;
        String pageName = "";
        boolean isDefault = false;
        Page page = item.getRegion().getPage();
        if (PageType.SUB_PAGE.equals((Object)page.getPageType())) {
            pageId = page.getId();
            pageName = page.getName();
            isDefault = this.isDefaultSubPage(page);
        }
        return String.format(SCRIPT_BLOCK, item.getRegion().getId(), "W3C", item.getId(), contextualizedWidget.getUrl(), height, width, item.isCollapsed(), item.getWidgetId(), item.isLocked(), item.isHideChrome(), pageId, pageName, isDefault, JsonUtils.stringify((Object)widget.getProperties()));
    }

    private boolean isDefaultSubPage(Page subPage) {
        return ((Page)subPage.getParentPage().getSubPages().get(0)).getId().equals(subPage.getId());
    }
}

