/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.api.rest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.rave.model.Page;
import org.apache.rave.model.Region;
import org.apache.rave.model.RegionWidget;
import org.apache.rave.portal.model.util.omdl.OmdlOutputAdapter;
import org.apache.rave.portal.service.OmdlService;
import org.apache.rave.portal.service.PageService;
import org.apache.rave.portal.web.api.rest.AbstractRestApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="restPageApi")
@RequestMapping(value={"/api/rest/page/*"})
public class PageApi
extends AbstractRestApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private PageService pageService;
    private OmdlService omdlService;

    @Autowired
    public PageApi(PageService pageService, OmdlService omdlService) {
        this.pageService = pageService;
        this.omdlService = omdlService;
    }

    @RequestMapping(value={"{pageId}"}, method={RequestMethod.DELETE})
    public void deletePage(@PathVariable String pageId, HttpServletResponse response) {
        this.logger.debug("DELETE received for /api/rest/page/" + pageId);
        this.pageService.deletePage(pageId);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @ResponseBody
    @RequestMapping(value={"{pageId}/omdl"}, method={RequestMethod.GET})
    public OmdlOutputAdapter getOmdl(@PathVariable String pageId, HttpServletRequest request, HttpServletResponse response) {
        this.logger.debug("GET received for /api/rest/page/" + pageId + "/omdl");
        response.setHeader("Content-Disposition", "attachment; filename=\"rave-omdl-page-" + pageId + ".xml\"");
        return this.omdlService.exportOmdl(pageId, request.getRequestURL().toString());
    }

    @ResponseBody
    @RequestMapping(value={"{pageId}"}, method={RequestMethod.GET})
    public Page getPage(@PathVariable String pageId, @RequestParam(required=false) boolean export) {
        this.logger.debug("GET received for /api/rest/page/" + pageId);
        Page page = this.pageService.getPage(pageId);
        if (export) {
            PageApi.modifyForExport(page);
        }
        return page;
    }

    private static void modifyForExport(Page page) {
        page.setOwnerId(null);
        for (Region r : page.getRegions()) {
            PageApi.modifyForExport(r);
        }
    }

    private static void modifyForExport(Region r) {
        for (RegionWidget w : r.getRegionWidgets()) {
            w.setPreferences(null);
        }
    }
}

