/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.api.rpc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rave.model.Widget;
import org.apache.rave.portal.service.WidgetMetadataResolver;
import org.apache.rave.portal.service.WidgetService;
import org.apache.rave.portal.web.api.rpc.model.RpcOperation;
import org.apache.rave.portal.web.api.rpc.model.RpcResult;
import org.apache.rave.rest.model.SearchResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="rpcWidgetApi")
@RequestMapping(value={"/api/rpc/widget/*"})
public class WidgetApi {
    private Map<String, WidgetMetadataResolver> widgetMetadataResolverMap;
    private WidgetService widgetService;

    @Autowired
    public WidgetApi(List<WidgetMetadataResolver> widgetMetadataResolvers, WidgetService widgetService) {
        this.widgetService = widgetService;
        this.widgetMetadataResolverMap = new HashMap<String, WidgetMetadataResolver>();
        for (WidgetMetadataResolver widgetMetadataResolver : widgetMetadataResolvers) {
            this.widgetMetadataResolverMap.put(widgetMetadataResolver.getSupportedContext(), widgetMetadataResolver);
        }
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"metadata/get"})
    public RpcResult<Widget> getWidgetMetadata(final @RequestParam String url, final @RequestParam String type) {
        return new RpcOperation<Widget>(){

            @Override
            public Widget execute() {
                if (WidgetApi.this.widgetMetadataResolverMap.get(type) == null) {
                    throw new IllegalArgumentException("Get Metadata for provider " + type + " is not implemented");
                }
                return ((WidgetMetadataResolver)WidgetApi.this.widgetMetadataResolverMap.get(type)).getMetadata(url);
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"metadatagroup/get"})
    public RpcResult<Widget[]> getWidgetMetadataGroup(final @RequestParam String url, final @RequestParam String type) {
        return new RpcOperation<Widget[]>(){

            @Override
            public Widget[] execute() {
                if (WidgetApi.this.widgetMetadataResolverMap.get(type) == null) {
                    throw new IllegalArgumentException("Get Metadata group for provider " + type + " is not implemented");
                }
                return ((WidgetMetadataResolver)WidgetApi.this.widgetMetadataResolverMap.get(type)).getMetadataGroup(url);
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"getall"})
    public RpcResult<SearchResult<Widget>> getAllWidgets() {
        return new RpcOperation<SearchResult<Widget>>(){

            @Override
            public SearchResult<Widget> execute() {
                SearchResult results = WidgetApi.this.widgetService.getAll();
                for (Widget widget : results.getResultSet()) {
                    widget.setOwnerId(null);
                    widget.setTags(null);
                }
                return results;
            }
        }.getResult();
    }
}

