/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller;

import org.apache.rave.portal.model.impl.UserImpl;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.web.controller.util.ModelUtils;
import org.apache.rave.portal.web.model.UserForm;
import org.apache.rave.portal.web.validator.ChangePasswordValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class ChangePasswordController {
    private static Logger log = LoggerFactory.getLogger(ChangePasswordController.class);
    private final UserService userService;
    private final ChangePasswordValidator passwordValidator;
    @Value(value="#{messages['page.newpassword.message.success']}")
    private String messagePasswordChanged;

    @Autowired
    public ChangePasswordController(UserService userService, ChangePasswordValidator passwordValidator) {
        this.userService = userService;
        this.passwordValidator = passwordValidator;
    }

    @RequestMapping(value={"/changepassword/{passwordHash:.*}"}, method={RequestMethod.GET})
    public String initialize(Model model, @PathVariable(value="passwordHash") String passwordHash) {
        log.debug("Requesting user for hash: {}", (Object)passwordHash);
        UserImpl user = new UserImpl();
        model.addAttribute("user", (Object)user);
        user.setForgotPasswordHash(passwordHash);
        return "templates.user.changepassword";
    }

    @RequestMapping(value={"/changepassword", "/changepassword/**"}, method={RequestMethod.POST})
    public String update(@ModelAttribute UserForm user, BindingResult results, Model model, RedirectAttributes redirectAttributes) {
        log.debug("updating user password for hash {}", (Object)user.getForgotPasswordHash());
        model.addAttribute("user", (Object)user);
        this.passwordValidator.validate(user, (Errors)results);
        if (results.hasErrors()) {
            log.info("changepassword, request contains validation errors");
            return "templates.user.changepassword";
        }
        try {
            log.debug("Submitted passwords were valid");
            this.userService.updatePassword(ModelUtils.convert(user));
            redirectAttributes.addFlashAttribute("message", (Object)this.messagePasswordChanged);
            return "redirect:/login";
        }
        catch (Exception ex) {
            results.reject("Unable to change password:" + ex.getMessage(), "Unable to change password.");
            return "templates.user.changepassword";
        }
    }
}

