/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.rave.model.Page;
import org.apache.rave.model.Person;
import org.apache.rave.model.User;
import org.apache.rave.portal.service.PageService;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.web.controller.util.ControllerUtils;
import org.apache.rave.portal.web.model.NavigationItem;
import org.apache.rave.portal.web.model.NavigationMenu;
import org.apache.rave.portal.web.model.UserForm;
import org.apache.rave.portal.web.util.ViewNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/person/*", "/person"})
public class ProfileController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final UserService userService;
    private final PageService pageService;

    @Autowired
    public ProfileController(UserService userService, PageService pageService) {
        this.userService = userService;
        this.pageService = pageService;
    }

    @RequestMapping(value={"/{username:.*}"}, method={RequestMethod.GET})
    public String viewProfileByUsername(@PathVariable String username, ModelMap model, @RequestParam(required=false) String referringPageId, HttpServletResponse response) {
        User user = null;
        try {
            user = this.userService.getUserByUsername(username);
            this.logger.debug("Viewing person profile for: " + user.getUsername());
            return this.viewProfileCommon(user, model, referringPageId);
        }
        catch (Exception e) {
            return this.profileNotFoundErrorHelper(model, referringPageId, response, user, e);
        }
    }

    @RequestMapping(value={"/id/{userid:.*}"}, method={RequestMethod.GET})
    public String viewProfile(@PathVariable String userid, ModelMap model, @RequestParam(required=false) String referringPageId, HttpServletResponse response) {
        User user = null;
        try {
            user = this.userService.getUserById(userid);
            this.logger.debug("Viewing person profile for: " + user.getUsername());
            return this.viewProfileCommon(user, model, referringPageId);
        }
        catch (Exception e) {
            return this.profileNotFoundErrorHelper(model, referringPageId, response, user, e);
        }
    }

    private String profileNotFoundErrorHelper(ModelMap model, String referringPageId, HttpServletResponse response, User user, Exception e) {
        this.logger.error("Caught an exception: " + e.getMessage());
        this.addAttributesToModel(model, user, referringPageId);
        response.setStatus(HttpStatus.NOT_FOUND.value());
        String view = "templates.user.usernotfound";
        ProfileController.addNavItemsToModel(view, model, referringPageId, user, null);
        return view;
    }

    private String viewProfileCommon(User user, ModelMap model, String referringPageId) {
        Page personProfilePage = this.pageService.getPersonProfilePage(user.getId());
        this.addAttributesToModel(model, user, referringPageId);
        model.addAttribute("page", (Object)personProfilePage);
        String view = ViewNames.getPersonPageView(personProfilePage.getPageLayout().getCode());
        List friendRequests = this.userService.getFriendRequestsReceived(user.getUsername());
        ProfileController.addNavItemsToModel(view, model, referringPageId, user, friendRequests);
        return view;
    }

    @RequestMapping(method={RequestMethod.POST})
    public String updateProfile(ModelMap model, @RequestParam(required=false) String referringPageId, @ModelAttribute(value="updatedUser") UserForm updatedUser) {
        User user = this.userService.getAuthenticatedUser();
        this.logger.info("Updating " + user.getUsername() + " profile information");
        user.setGivenName(updatedUser.getGivenName());
        user.setFamilyName(updatedUser.getFamilyName());
        user.setDisplayName(updatedUser.getDisplayName());
        user.setAboutMe(updatedUser.getAboutMe());
        user.setStatus(updatedUser.getStatus());
        user.setEmail(updatedUser.getEmail());
        this.userService.updateUserProfile(user);
        this.addAttributesToModel(model, user, referringPageId);
        return "redirect:/app/person/" + user.getUsername();
    }

    private void addAttributesToModel(ModelMap model, User user, String referringPageId) {
        model.addAttribute("userProfile", (Object)user);
        model.addAttribute("referringPageId", (Object)referringPageId);
    }

    public static void addNavItemsToModel(String view, ModelMap model, String referringPageId, User user, List<Person> friendRequests) {
        String refPageId = referringPageId != null ? referringPageId : "";
        NavigationMenu topMenu = new NavigationMenu("topnav");
        if (friendRequests != null) {
            NavigationItem friendRequestItems = new NavigationItem("page.profile.friend.requests", String.valueOf(friendRequests.size()), "#");
            for (Person request : friendRequests) {
                NavigationItem childItem = new NavigationItem(request.getDisplayName() != null && !request.getDisplayName().isEmpty() ? request.getDisplayName() : request.getUsername(), request.getUsername(), "#");
                friendRequestItems.addChildNavigationItem(childItem);
            }
            topMenu.addNavigationItem(friendRequestItems);
        }
        topMenu.getNavigationItems().addAll(ControllerUtils.getTopMenu(view, refPageId, user, false).getNavigationItems());
        model.addAttribute(topMenu.getName(), (Object)topMenu);
    }
}

