/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller;

import org.apache.rave.model.PortalPreference;
import org.apache.rave.model.User;
import org.apache.rave.model.Widget;
import org.apache.rave.model.WidgetStatus;
import org.apache.rave.portal.model.impl.WidgetImpl;
import org.apache.rave.portal.service.CategoryService;
import org.apache.rave.portal.service.PortalPreferenceService;
import org.apache.rave.portal.service.TagService;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.service.WidgetService;
import org.apache.rave.portal.web.controller.util.ControllerUtils;
import org.apache.rave.portal.web.validator.NewWidgetValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/store/*", "/store"})
public class WidgetStoreController {
    private static final int MAXIMUM_WIDGETS_PER_PAGE = 10;
    private final WidgetService widgetService;
    private final NewWidgetValidator widgetValidator;
    private final UserService userService;
    private final PortalPreferenceService preferenceService;
    private final TagService tagService;
    private final CategoryService categoryService;

    @Autowired
    public WidgetStoreController(WidgetService widgetService, NewWidgetValidator validator, UserService userService, PortalPreferenceService preferenceService, TagService tagService, CategoryService categoryService) {
        this.widgetService = widgetService;
        this.widgetValidator = validator;
        this.userService = userService;
        this.preferenceService = preferenceService;
        this.tagService = tagService;
        this.categoryService = categoryService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String view(Model model, @RequestParam String referringPageId, @RequestParam(required=false, defaultValue="0") int offset) {
        String view = "templates.user.store";
        User user = this.userService.getAuthenticatedUser();
        this.widgetStoreModelHelper(model, referringPageId, user, "templates.user.store");
        model.addAttribute("widgets", (Object)this.widgetService.getPublishedWidgets(offset, this.getPageSize()));
        return "templates.user.store";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"mine"})
    public String viewMine(Model model, @RequestParam String referringPageId, @RequestParam(required=false, defaultValue="0") int offset) {
        String view = "templates.user.store";
        User user = this.userService.getAuthenticatedUser();
        this.widgetStoreModelHelper(model, referringPageId, user, "templates.user.store");
        model.addAttribute("widgets", (Object)this.widgetService.getWidgetsByOwner(user.getId(), offset, this.getPageSize()));
        return "templates.user.store";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"widget/{widgetId}"})
    public String viewWidget(Model model, @PathVariable String widgetId, @RequestParam String referringPageId) {
        String view = "templates.user.widget";
        User user = this.userService.getAuthenticatedUser();
        this.widgetStoreModelHelper(model, referringPageId, user, "templates.user.widget");
        model.addAttribute("widget", (Object)this.widgetService.getWidget(widgetId));
        model.addAttribute("widgetStatistics", (Object)this.widgetService.getWidgetStatistics(widgetId, user.getId()));
        model.addAttribute("userProfile", (Object)user);
        return "templates.user.widget";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"search"})
    public String viewSearchResult(Model model, @RequestParam String referringPageId, @RequestParam String searchTerm, @RequestParam(required=false, defaultValue="0") int offset) {
        String view = "templates.user.store";
        User user = this.userService.getAuthenticatedUser();
        this.widgetStoreModelHelper(model, referringPageId, user, "templates.user.store");
        model.addAttribute("widgets", (Object)this.widgetService.getPublishedWidgetsByFreeTextSearch(searchTerm, offset, this.getPageSize()));
        model.addAttribute("searchTerm", (Object)searchTerm);
        model.addAttribute("offset", (Object)offset);
        return "templates.user.store";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"tag"})
    public String viewTagResult(Model model, @RequestParam String referringPageId, @RequestParam String keyword, @RequestParam(required=false, defaultValue="0") int offset) {
        String view = "templates.user.store";
        User user = this.userService.getAuthenticatedUser();
        this.widgetStoreModelHelper(model, referringPageId, user, "templates.user.store");
        model.addAttribute("widgets", (Object)this.widgetService.getWidgetsByTag(keyword, offset, this.getPageSize()));
        model.addAttribute("offset", (Object)offset);
        model.addAttribute("selectedTag", (Object)keyword);
        return "templates.user.store";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"category"})
    public String viewCategoryResult(@RequestParam(required=true) String referringPageId, @RequestParam(required=true) String categoryId, @RequestParam(required=false, defaultValue="0") int offset, Model model) {
        String view = "templates.user.store";
        User authenticatedUser = this.userService.getAuthenticatedUser();
        this.widgetStoreModelHelper(model, referringPageId, authenticatedUser, "templates.user.store");
        if (categoryId != null && !categoryId.isEmpty()) {
            model.addAttribute("widgets", (Object)this.widgetService.getWidgetsByCategory(categoryId, offset, this.getPageSize()));
        } else {
            model.addAttribute("widgets", (Object)this.widgetService.getPublishedWidgets(offset, this.getPageSize()));
        }
        model.addAttribute("offset", (Object)offset);
        model.addAttribute("selectedCategory", (Object)categoryId);
        return "templates.user.store";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"widget/add"})
    public String viewAddWidgetForm(Model model, @RequestParam String referringPageId) {
        WidgetImpl widget = new WidgetImpl();
        String view = "templates.user.addwidget";
        model.addAttribute("marketplace", (Object)this.preferenceService.getPreference("externalMarketplaceUrl"));
        model.addAttribute("widget", (Object)widget);
        model.addAttribute("referringPageId", (Object)referringPageId);
        ControllerUtils.addNavItemsToModel("templates.user.addwidget", model, referringPageId, this.userService.getAuthenticatedUser());
        return "templates.user.addwidget";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"widget/add/{type}"})
    public String viewAddWidgetFormByType(Model model, @RequestParam String referringPageId, @PathVariable String type) {
        WidgetImpl widget = new WidgetImpl();
        String view = type != null && type.equalsIgnoreCase("w3c") ? "templates.user.addwidget.w3c" : "templates.user.addwidget";
        model.addAttribute("marketplace", (Object)this.preferenceService.getPreference("externalMarketplaceUrl"));
        model.addAttribute("widget", (Object)widget);
        model.addAttribute("referringPageId", (Object)referringPageId);
        ControllerUtils.addNavItemsToModel(view, model, referringPageId, this.userService.getAuthenticatedUser());
        return view;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"widget/add"})
    public String viewAddWidgetResult(@ModelAttribute WidgetImpl widget, BindingResult results, Model model, @RequestParam String referringPageId) {
        User user = this.userService.getAuthenticatedUser();
        this.widgetValidator.validate(widget, (Errors)results);
        if (results.hasErrors()) {
            String view = "templates.user.addwidget";
            model.addAttribute("widget", (Object)widget);
            model.addAttribute("referringPageId", (Object)referringPageId);
            ControllerUtils.addNavItemsToModel("templates.user.addwidget", model, referringPageId, user);
            return "templates.user.addwidget";
        }
        return this.finalizeNewWidget(widget, user, referringPageId);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"widget/add/w3c"})
    public String viewAddWidgetResultW3c(@ModelAttribute WidgetImpl widget, BindingResult results, Model model, @RequestParam String referringPageId) {
        User user = this.userService.getAuthenticatedUser();
        this.widgetValidator.validate(widget, (Errors)results);
        if (results.hasErrors()) {
            String view = "templates.user.addwidget.w3c";
            model.addAttribute("widget", (Object)widget);
            model.addAttribute("referringPageId", (Object)referringPageId);
            ControllerUtils.addNavItemsToModel("templates.user.addwidget.w3c", model, referringPageId, user);
            return "templates.user.addwidget.w3c";
        }
        return this.finalizeNewWidget(widget, user, referringPageId);
    }

    private String finalizeNewWidget(WidgetImpl widget, User user, String referringPageId) {
        PortalPreference status = this.preferenceService.getPreference("initialWidgetStatus");
        if (status != null && status.getValue().equals("PUBLISHED")) {
            widget.setWidgetStatus(WidgetStatus.PUBLISHED);
        } else {
            widget.setWidgetStatus(WidgetStatus.PREVIEW);
        }
        widget.setOwnerId(user.getId());
        Widget storedWidget = this.widgetService.registerNewWidget((Widget)widget);
        return "redirect:/app/store/widget/" + storedWidget.getId() + "?referringPageId=" + referringPageId;
    }

    private void widgetStoreModelHelper(Model model, String referringPageId, User user, String view) {
        model.addAttribute("referringPageId", (Object)referringPageId);
        model.addAttribute("widgetsStatistics", (Object)this.widgetService.getAllWidgetStatistics(user.getId()));
        model.addAttribute("tags", (Object)this.tagService.getAllTagsList());
        model.addAttribute("categories", (Object)this.categoryService.getAllList());
        ControllerUtils.addNavItemsToModel(view, model, referringPageId, user);
    }

    public int getPageSize() {
        PortalPreference pageSizePref = this.preferenceService.getPreference("pageSize");
        if (pageSizePref == null) {
            return 10;
        }
        try {
            return Integer.parseInt(pageSizePref.getValue());
        }
        catch (NumberFormatException e) {
            return 10;
        }
    }
}

